<?php
require_once __DIR__ . '/../security.php';
require_once __DIR__ . '/../lib/participant_helper.php';

// Säkerhetsheaders tidigt
setSecurityHeaders();

// Hämta user_id från GET eller cookie (session används endast som följd av dessa)
if (session_status() === PHP_SESSION_NONE) {
    @session_start();
}

$rawUserId = '';
if (isset($_GET['user_id']) && $_GET['user_id'] !== '') {
    $rawUserId = $_GET['user_id'];
} elseif (isset($_COOKIE['user_id']) && $_COOKIE['user_id'] !== '') {
    $rawUserId = $_COOKIE['user_id'];
} elseif (isset($_SESSION['user_id']) && $_SESSION['user_id'] !== '') {
    // Använd session som fallback om GET och cookie saknas
    $rawUserId = $_SESSION['user_id'];
} else {
    $rawUserId = '';
}
$userId = sanitizeInput($rawUserId, 'user_id');

// Spara i session för navigering mellan sidor
if (!empty($userId)) {
    $_SESSION['user_id'] = $userId;
    // Spara även i cookie (8 timmar), SameSite=Lax
    $expires = time() + 8 * 60 * 60;
    setcookie('user_id', $userId, [
        'expires' => $expires,
        'path' => '/',
        'secure' => isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on',
        'httponly' => false,
        'samesite' => 'Lax',
    ]);
} else {
    // Ingen cookie och ingen GET-param: lita inte på gammal session
    unset($_SESSION['user_id']);
}

$rootDir = realpath(__DIR__ . '/../') ?: dirname(__DIR__);
$userFile = $rootDir . '/data/userids.json';
$users = [];
if (file_exists($userFile)) {
    $raw = file_get_contents($userFile);
    $users = json_decode($raw, true) ?: [];
}

$isAdmin = false;
$isInactive = false;
if (!empty($userId) && is_array($users)) {
    foreach ($users as $u) {
        if (($u['user_id'] ?? '') === $userId) {
            $userType = $u['user_type'] ?? 'user';
            if ($userType === 'admin') {
                $isAdmin = true;
            }
            // Kontrollera om användaren är aktiv
            if (!isParticipantActive($userId)) {
                $isInactive = true;
            }
            break;
        }
    }
}

// Om användaren är inaktiv (oavsett om de är admin eller inte), redirecta till "åtkomst nekad"
if ($isInactive) {
    header('Location: check_admin.php?user_id=' . urlencode($userId));
    exit;
}

if (!$isAdmin) {
    // Omdirigera till index.html där användaren kan ange sitt UUID
    // Behåll user_id i URL om det finns
    $redirectUrl = '../index.html';
    if (!empty($userId)) {
        $redirectUrl .= '?user_id=' . urlencode($userId);
    }
    header('Location: ' . $redirectUrl);
    exit;
}
?>


