<?php
// Starta output buffering tidigt och stäng av display_errors
ob_start();
error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);

require_once __DIR__ . '/../../admin_guard.php';
require_once __DIR__ . '/../../../security.php';
require_once __DIR__ . '/../../../config.php';

// Säkerhetsheaders
setSecurityHeaders();

// Rensa output buffer efter require_once
ob_clean();

// Kontrollera att ZipArchive är tillgängligt
if (!class_exists('ZipArchive')) {
    http_response_code(500);
    die('ZipArchive-klassen är inte tillgänglig. Installera php-zip.');
}

// Sökvägar
$projectsFile = __DIR__ . '/../../../data/projects.json';
$chatsDir = __DIR__ . '/../../../chats';
$uploadsDir = __DIR__ . '/../../../uploads';

// Hämta parametrar
$projectId = sanitizeInput($_GET['project_id'] ?? '', 'project_id');
$userId = sanitizeInput($_GET['user_id'] ?? '', 'user_id');

if (empty($projectId) || empty($userId)) {
    http_response_code(400);
    die('Projekt-ID och user_id krävs');
}

// Validera admin-rättigheter
require_once __DIR__ . '/../../../lib/participant_helper.php';
if (!isParticipantAdmin($userId)) {
    http_response_code(403);
    die('Endast administratörer kan ladda ner chattar');
}

// Kontrollera att projektet finns
$projects = [];
if (file_exists($projectsFile)) {
    $content = file_get_contents($projectsFile);
    if ($content !== false) {
        $projects = json_decode($content, true) ?: [];
    }
}

$projectName = $projectId;
foreach ($projects as $project) {
    if (($project['id'] ?? '') === $projectId) {
        $projectName = $project['name'] ?? $projectId;
        break;
    }
}

// Skapa ZIP-fil
$zipFileName = 'chat_' . $projectId . '_' . date('Ymd_His') . '.zip';
$zipPath = sys_get_temp_dir() . '/' . $zipFileName;

// Ta bort gammal ZIP om den finns
if (file_exists($zipPath)) {
    @unlink($zipPath);
}

$zip = new ZipArchive();
$result = $zip->open($zipPath, ZipArchive::CREATE | ZipArchive::OVERWRITE);
if ($result !== TRUE) {
    http_response_code(500);
    die('Kunde inte skapa ZIP-fil. Felkod: ' . $result);
}

$addedFiles = 0;

// Lägg till messages.json om den finns
$messagesFile = $chatsDir . '/' . $projectId . '/messages.json';
if (file_exists($messagesFile) && is_readable($messagesFile)) {
    $content = file_get_contents($messagesFile);
    if ($content !== false) {
        if ($zip->addFromString('messages.json', $content)) {
            $addedFiles++;
        }
    }
}

// Lägg till alla bilder från chats-mappen (där chatbilder sparas)
$projectChatDir = $chatsDir . '/' . $projectId;
if (is_dir($projectChatDir) && is_readable($projectChatDir)) {
    $files = scandir($projectChatDir);
    foreach ($files as $file) {
        if ($file === '.' || $file === '..' || $file === 'messages.json') {
            continue; // Hoppa över messages.json och kataloger
        }
        
        $filePath = $projectChatDir . '/' . $file;
        if (is_file($filePath) && is_readable($filePath)) {
            // Lägg till bildfiler, thumbnails
            $ext = strtolower(pathinfo($file, PATHINFO_EXTENSION));
            $allowedExts = ['jpg', 'jpeg', 'png', 'webp', 'heic', 'heif', 'mp4', 'webm', 'mov', 'avi'];
            
            // Kontrollera om filen är en bild/video eller thumbnail
            $isThumbnail = strpos($file, '-thumb.jpg') !== false;
            $isAllowedExt = in_array($ext, $allowedExts);
            
            if ($isAllowedExt || $isThumbnail) {
                // Försök lägga till filen i ZIP
                // Använd addFile för att undvika minnesproblem med stora filer
                $result = $zip->addFile($filePath, 'chats/' . $projectId . '/' . $file);
                if ($result) {
                    $addedFiles++;
                } else {
                    // Om addFile misslyckas, försök med addFromString (kan vara minneskrävande)
                    $fileContent = @file_get_contents($filePath);
                    if ($fileContent !== false) {
                        if ($zip->addFromString('chats/' . $projectId . '/' . $file, $fileContent)) {
                            $addedFiles++;
                        }
                    }
                }
            }
        }
    }
}

// Om inga filer lades till, lägg till en tom README
if ($addedFiles === 0) {
    $zip->addFromString('README.txt', 'Inga filer hittades för detta projekt. Projekt-ID: ' . $projectId . "\nUploads-mapp: " . $projectUploadDir);
}

// Stäng ZIP-filen korrekt
$closeResult = $zip->close();
if ($closeResult !== TRUE) {
    @unlink($zipPath);
    http_response_code(500);
    die('Kunde inte stänga ZIP-fil. Felkod: ' . $closeResult);
}

// Verifiera att ZIP-filen skapades korrekt
if (!file_exists($zipPath)) {
    http_response_code(500);
    die('ZIP-filen skapades inte');
}

$fileSize = filesize($zipPath);
if ($fileSize < 22) { // Minsta ZIP-storlek är ~22 bytes (tom ZIP)
    @unlink($zipPath);
    http_response_code(500);
    die('ZIP-filen är för liten eller korrupt. Inga filer lades till.');
}

// Verifiera ZIP-filen genom att försöka öppna den
$testZip = new ZipArchive();
$testResult = $testZip->open($zipPath, ZipArchive::CHECKCONS);
if ($testResult !== TRUE) {
    @unlink($zipPath);
    http_response_code(500);
    die('ZIP-filen är korrupt. Felkod: ' . $testResult);
}
$testZip->close();

// Rensa output buffer innan vi skickar filen
while (ob_get_level()) {
    ob_end_clean();
}

// Skicka ZIP-filen till användaren
header('Content-Type: application/zip');
header('Content-Disposition: attachment; filename="' . $zipFileName . '"');
header('Content-Length: ' . $fileSize);
header('Cache-Control: no-cache, must-revalidate');
header('Pragma: no-cache');
header('Content-Transfer-Encoding: binary');

// Skicka filen
readfile($zipPath);

// Ta bort temporär fil
@unlink($zipPath);
exit;
?>
