<?php
require_once __DIR__ . '/../admin_guard.php';
require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../../security.php';
require_once __DIR__ . '/../../lib/participant_helper.php';
require_once __DIR__ . '/../../lib/dal/repositories/ProjectRepository.php';

// Svara alltid JSON
header('Content-Type: application/json; charset=utf-8');

// Skapa repository
$projectRepo = new ProjectRepository();

// Hämta action från URL
$action = $_GET['action'] ?? '';

try {
  switch ($action) {
    case 'list':
      $projects = $projectRepo->getAll();
      echo json_encode([
        'success' => true,
        'projects' => $projects
      ]);
      break;
      
    case 'get':
      $projectId = $_GET['project_id'] ?? '';
      
      if (empty($projectId)) {
        throw new Exception('Project ID krävs');
      }
      
      $project = $projectRepo->getById($projectId);
      
      if ($project === null) {
        throw new Exception('Projekt hittades inte');
      }
      
      echo json_encode([
        'success' => true,
        'project' => $project
      ]);
      break;
      
    case 'add':
      $id = trim($_POST['id'] ?? '');
      $name = trim($_POST['name'] ?? '');
      $description = trim($_POST['description'] ?? '');
      $startDate = $_POST['startDate'] ?? '';
      
      if (empty($id)) {
        throw new Exception('Projekt-ID krävs');
      }
      
      if (empty($name)) {
        throw new Exception('Projektnamn krävs');
      }
      
      // Kontrollera om projekt-ID redan finns
      $existingProject = $projectRepo->getById($id);
      if ($existingProject !== null) {
        throw new Exception('Ett projekt med detta ID finns redan');
      }
      
      // Hämta user_id från admin_guard.php (finns redan i $userId variabel)
      // $userId är redan satt av admin_guard.php
      
      $newProject = [
        'id' => $id,
        'name' => $name,
        'description' => $description,
        'startDate' => $startDate,
        'status' => 'active',
        'created_at' => date('Y-m-d H:i:s'),
        'participants' => []
      ];
      
      // Lägg till skaparen som deltagare om user_id finns
      if (!empty($userId)) {
        $newProject['participants'][] = [
          'type' => 'user',
          'participant_id' => $userId,
          'added_at' => date('c'),
          'added_by' => $userId
        ];
      }
      
      // Lägg till alla admins som deltagare
      $adminIds = getAllAdminUserIds();
      foreach ($adminIds as $adminId) {
        // Kontrollera att admin inte redan är deltagare (t.ex. om skaparen är admin)
        $alreadyParticipant = false;
        foreach ($newProject['participants'] as $p) {
          $pid = $p['participant_id'] ?? '';
          if ($pid === $adminId) {
            $alreadyParticipant = true;
            break;
          }
        }
        if (!$alreadyParticipant) {
          $newProject['participants'][] = [
            'type' => 'user',
            'participant_id' => $adminId,
            'added_at' => date('c'),
            'added_by' => 'system'
          ];
        }
      }
      
      if ($projectRepo->create($newProject)) {
        echo json_encode([
          'success' => true,
          'message' => 'Projekt skapat',
          'project' => $newProject
        ]);
      } else {
        throw new Exception('Kunde inte spara projekt');
      }
      break;
      
    case 'update':
      $projectId = $_POST['projectId'] ?? '';
      $name = trim($_POST['name'] ?? '');
      $description = trim($_POST['description'] ?? '');
      $startDate = $_POST['startDate'] ?? '';
      $archived = isset($_POST['archived']) && $_POST['archived'] === '1';
      $status = $_POST['status'] ?? 'active';
      
      if (empty($projectId) || empty($name)) {
        throw new Exception('Projekt-ID och namn krävs');
      }
      
      $project = $projectRepo->getById($projectId);
      if ($project === null) {
        throw new Exception('Projekt hittades inte');
      }
      
      $project['name'] = $name;
      $project['description'] = $description;
      $project['startDate'] = $startDate;
      $project['status'] = $archived ? 'archived' : 'active';
      $project['updated_at'] = date('Y-m-d H:i:s');
      
      if ($projectRepo->update($projectId, $project)) {
        echo json_encode([
          'success' => true,
          'message' => 'Projekt uppdaterat'
        ]);
      } else {
        throw new Exception('Kunde inte spara ändringar');
      }
      break;
      
    case 'toggle_status':
      $projectId = $_POST['projectId'] ?? '';
      
      if (empty($projectId)) {
        throw new Exception('Projekt-ID krävs');
      }
      
      $project = $projectRepo->getById($projectId);
      if ($project === null) {
        throw new Exception('Projekt hittades inte');
      }
      
      $project['status'] = $project['status'] === 'active' ? 'archived' : 'active';
      $project['updated_at'] = date('Y-m-d H:i:s');
      
      if ($projectRepo->update($projectId, $project)) {
        $updatedProject = $projectRepo->getById($projectId);
        echo json_encode([
          'success' => true,
          'message' => 'Projektstatus ändrad',
          'project' => $updatedProject
        ]);
      } else {
        throw new Exception('Kunde inte spara ändringar');
      }
      break;
      
    case 'delete':
      $projectId = $_POST['projectId'] ?? '';
      
      if (empty($projectId)) {
        throw new Exception('Projekt-ID krävs');
      }
      
      $project = $projectRepo->getById($projectId);
      if ($project === null) {
        throw new Exception('Projekt hittades inte');
      }
      
      if ($projectRepo->delete($projectId)) {
        echo json_encode([
          'success' => true,
          'message' => 'Projekt borttaget'
        ]);
      } else {
        throw new Exception('Kunde inte spara ändringar');
      }
      break;
      
    default:
      throw new Exception('Ogiltig action');
  }
  
} catch (Exception $e) {
  http_response_code(400);
  echo json_encode([
    'success' => false,
    'message' => $e->getMessage()
  ]);
}
?>
