<?php
require_once __DIR__ . '/../admin_guard.php';
require_once __DIR__ . '/../config.php';

// Hantera POST-request för lösenordsbyte
$message = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $newSecret = trim($_POST['new_secret'] ?? '');
    $confirmSecret = trim($_POST['confirm_secret'] ?? '');
    
    // Validera input
    if (empty($newSecret) || empty($confirmSecret)) {
        $error = 'Båda fälten måste fyllas i.';
    } elseif ($newSecret !== $confirmSecret) {
        $error = 'Den nya koden matchar inte bekräftelsen.';
    } elseif (strlen($newSecret) < 4) {
        $error = 'Den nya koden måste vara minst 4 tecken lång.';
    } else {
        // PIN-kod för användaruppladdningar är nu inaktiverad
        // Admin-lösenord hanteras via admin_users.json
        $error = 'PIN-kod hantering är inaktiverad. Admin-lösenord hanteras via admin_users.json.';
    }
}
?>
<!DOCTYPE html>
<html lang="sv">
<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width,initial-scale=1" />
    <title>Byt kod - ByggArkiv</title>
    <style>
        body { 
            font-family: system-ui, -apple-system, Segoe UI, Roboto, sans-serif; 
            margin: 16px; 
            background-color: #f5f5f5;
        }
        .card { 
            border: 1px solid #ddd; 
            border-radius: 12px; 
            padding: 24px; 
            max-width: 480px; 
            margin: 0 auto;
            background: white;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
        h1 { 
            margin-top: 0; 
            color: #333; 
            text-align: center;
        }
        label { 
            display: block; 
            font-weight: 600; 
            margin: 16px 0 6px; 
            color: #555;
        }
        input[type="password"] {
            width: 100%; 
            padding: 12px; 
            border: 1px solid #ccc; 
            border-radius: 8px; 
            font-size: 16px;
            box-sizing: border-box;
        }
        button {
            display: block;
            width: 100%;
            padding: 14px; 
            border-radius: 10px; 
            border: 0; 
            font-size: 16px;
            font-weight: 600;
            cursor: pointer; 
            background: #1a73e8; 
            color: white; 
            margin-top: 20px;
        }
        button:hover {
            background: #1557b0;
        }
        .message { 
            color: #0a8f3f; 
            background: #e8f5e8;
            padding: 12px;
            border-radius: 6px;
            margin: 16px 0;
        }
        .error { 
            color: #b00020; 
            background: #ffebee;
            padding: 12px;
            border-radius: 6px;
            margin: 16px 0;
        }
        .back-link {
            text-align: center;
            margin-top: 20px;
        }
        .back-link a {
            color: #1a73e8;
            text-decoration: none;
        }
        .back-link a:hover {
            text-decoration: underline;
        }
        .requirements {
            background: #f8f9fa;
            padding: 12px;
            border-radius: 6px;
            margin: 16px 0;
            font-size: 14px;
            color: #666;
        }
    </style>
</head>
<body>
    <header style="text-align: center; margin-bottom: 20px;">
        <a href="index.html">
            <img src="../data/logo.png" alt="ByggArkiv Snickare Stefan" style="max-width: 100%; height: auto; max-height: 120px; display: block; margin: 0 auto;">
        </a>
        <div class="back-link" style="margin-top: 15px;">
            <a href="../admin.php">← Tillbaka till admin</a>
        </div>


    </header>
    
    
    <div class="card">
        <h1>Byt kod</h1>
        
        <?php if ($message): ?>
            <div class="message"><?= htmlspecialchars($message) ?></div>
        <?php endif; ?>
        
        <?php if ($error): ?>
            <div class="error"><?= htmlspecialchars($error) ?></div>
        <?php endif; ?>
        
        <div class="requirements">
            <strong>Krav för ny kod:</strong>
            <ul style="margin: 8px 0; padding-left: 20px;">
                <li>Minst 4 tecken lång</li>
                <li>Båda nya koderna måste matcha</li>
            </ul>
        </div>
        
        <form method="POST">
            <label for="new_secret">Ny kod</label>
            <input type="password" id="new_secret" name="new_secret" 
                   value="<?= htmlspecialchars($_POST['new_secret'] ?? '') ?>" 
                   required autocomplete="new-password">
            
            <label for="confirm_secret">Bekräfta ny kod</label>
            <input type="password" id="confirm_secret" name="confirm_secret" 
                   value="<?= htmlspecialchars($_POST['confirm_secret'] ?? '') ?>" 
                   required autocomplete="new-password">
            
            <button type="submit">Byt kod</button>
        </form>
        
    </div>
</body>
</html>
