<?php
require_once __DIR__ . '/../admin_guard.php';

// Sökvägar
$projectsFile = __DIR__ . '/../../data/projects.json';
$chatsDir = __DIR__ . '/../../chats';

// Funktion för att läsa projekt
function readProjects($filePath) {
    if (!file_exists($filePath)) {
        return [];
    }
    $content = file_get_contents($filePath);
    if ($content === false) {
        return [];
    }
    $projects = json_decode($content, true);
    return is_array($projects) ? $projects : [];
}

// Funktion för att läsa chatmeddelanden
function readChatMessages($projectId, $chatsDir) {
    $chatFile = $chatsDir . '/' . $projectId . '/messages.json';
    if (!file_exists($chatFile)) {
        return [];
    }
    $content = file_get_contents($chatFile);
    if ($content === false) {
        return [];
    }
    $messages = json_decode($content, true);
    return is_array($messages) ? $messages : [];
}

// Svara JSON
header('Content-Type: application/json; charset=utf-8');

// Läsa projekt
$projects = readProjects($projectsFile);

// Samla statistik för varje projekt
$chatStats = [];
foreach ($projects as $project) {
    $projectId = $project['id'] ?? '';
    if (empty($projectId)) {
        continue;
    }
    
    $messages = readChatMessages($projectId, $chatsDir);
    $totalMessages = count($messages);
    
    $chatStats[] = [
        'project_id' => $projectId,
        'project_name' => $project['name'] ?? 'Namnlöst projekt',
        'status' => $project['status'] ?? 'active',
        'total_messages' => $totalMessages
    ];
}

echo json_encode([
    'success' => true,
    'chatStats' => $chatStats
]);

