<?php
require_once __DIR__ . '/../security.php';
require_once __DIR__ . '/../lib/participant_helper.php';

setSecurityHeaders();

$userId = isset($_GET['user_id']) ? sanitizeInput($_GET['user_id'], 'user_id') : '';

$userFile = __DIR__ . '/../data/userids.json';
$users = [];
if (file_exists($userFile)) {
    $raw = file_get_contents($userFile);
    $users = json_decode($raw, true) ?: [];
}

$isAdmin = false;
$isInactive = false;
$userFound = false;
if (!empty($userId) && is_array($users)) {
    foreach ($users as $u) {
        if (($u['user_id'] ?? '') === $userId) {
            $userFound = true;
            $userType = $u['user_type'] ?? 'user';
            if ($userType === 'admin') {
                $isAdmin = true;
            }
            // Kontrollera om användaren är inaktiv
            $active = $u['active'] ?? true;
            if ($active === false || $active === 0 || $active === '0' || $active === 'false') {
                $isInactive = true;
            }
            break;
        }
    }
}

// Om användaren är inaktiv → visa "åtkomst nekad" (oavsett om de är admin eller inte)
if ($isInactive) {
    // Visa "åtkomst nekad" - hoppa över redirect
    http_response_code(403);
} elseif ($isAdmin) {
    // Endast aktiva admins redirectas till admin.php
    // Spara i session/cookie och gå till admin utan query
    if (session_status() === PHP_SESSION_NONE) { @session_start(); }
    $_SESSION['user_id'] = $userId;
    $expires = time() + 8 * 60 * 60;
    setcookie('user_id', $userId, [
        'expires' => $expires,
        'path' => '/',
        'secure' => isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on',
        'httponly' => false,
        'samesite' => 'Lax',
    ]);
    // Gå till admin-sidan (adm/admin.php, inte admin.php i roten)
    $redirect = 'admin.php';
    header('Location: ' . $redirect);
    exit;
} elseif (empty($userId) || !$userFound) {
    // Användaren finns inte i listan - redirecta till index
    header('Location: ../index.html');
    exit;
} else {
    // Användaren är aktiv men inte admin → visa "åtkomst nekad"
    http_response_code(403);
}

http_response_code(403);
?>
<!DOCTYPE html>
<html lang="sv">
<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width,initial-scale=1" />
    <title>Åtkomst nekad - ByggArkiv</title>
    <link rel="stylesheet" href="../common.css">
    <style>
        /* Sid-specifika stilar för check_admin.php */
        body {
            font-family: system-ui, -apple-system, Segoe UI, Roboto, sans-serif;
        }
        .header img, .logo {
            max-width: 100%;
            height: auto;
            max-height: 120px;
            display: block;
            margin: 0 auto;
        }
        .denied-card {
            max-width: 700px;
            margin: 40px auto;
            background: #fff;
            border-radius: 12px;
            border: 3px solid #d32f2f;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            padding: 24px;
            text-align: center;
        }
        .denied-title {
            color: #d32f2f;
            font-size: 22px;
            font-weight: 600;
            margin-bottom: 8px;
        }
        .denied-text {
            color: #666;
            margin-bottom: 16px;
        }
    </style>
    </head>
<body>
    <div class="container">
        <header class="header">
            <img src="../data/logo.png" alt="ByggArkiv Snickare Stefan" class="logo">
        </header>

        <div class="denied-card">
            <div class="denied-title">Åtkomst nekad</div>
            <?php if ($isInactive): ?>
                <div class="denied-text">Din användare är inaktiv och du har loggats ut från chatten.</div>
            <?php else: ?>
                <div class="denied-text">Du saknar rättigheter för att komma åt adminsidorna.</div>
            <?php endif; ?>
            <div class="denied-text" style="font-size: 12px; opacity: 0.8;">
                <?= htmlspecialchars($userId ?: 'okänd användare') ?>
            </div>
        </div>
    </div>
</body>
</html>


