<?php
require_once __DIR__ . '/../admin_guard.php';

$script = $_SERVER['SCRIPT_NAME'] ?? '';
$admPos = strpos($script, '/adm/');
$adminUrl = ($admPos !== false ? substr($script, 0, $admPos + 4) : '/adm') . '/admin.php';
?>
<!DOCTYPE html>
<html lang="sv">
<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width,initial-scale=1" />
    <title>Systemdiagnostik - ByggArkiv</title>
    <link rel="stylesheet" href="../common.css">
    <style>
        /* Sid-specifika stilar för diag.php */
        .diagnostic-title {
            text-align: center;
            color: #333;
            margin-bottom: 30px;
            font-size: 28px;
            font-weight: 600;
        }
        .diagnostic-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 24px;
            margin-top: 30px;
        }
    </style>
</head>
<body>
    <div class="container">
        <header class="header">
            <a href="../../index.html">
                <img src="../../data/logo.png" alt="ByggArkiv Snickare Stefan" class="logo">
            </a>
        </header>

        <div class="back-link">
            <a href="<?= htmlspecialchars($adminUrl) ?>">← Tillbaka till admin</a>
        </div>

        <h1 class="diagnostic-title">Systemdiagnostik</h1>

        <div class="diagnostic-grid">
            <div class="diagnostic-card">
                <h3>Aktivitetslogg</h3>
                <p>Visa tidslinje över systemaktivitet: chat-meddelanden, bilduppladdningar, dokument, zip-paketeringar och systemmeddelanden. Filtrera efter datumintervall.</p>
                <a href="activity_timeline.php<?= !empty($_GET['user_id'] ?? '') ? '?user_id=' . urlencode($_GET['user_id']) : '' ?>" class="diagnostic-button">
                    Öppna aktivitetslogg
                </a>
            </div>
            <div class="diagnostic-card">
                <h3>Systemdiagnostik</h3>
                <p>Kontrollera systemstatus, filrättigheter, konfiguration och PHP-moduler. Visar detaljerad information om systemets hälsa och konfiguration.</p>
                <a href="system_diag.php" class="diagnostic-button" target="_blank">
                    Kör systemdiagnostik
                </a>
            </div>
            <div class="diagnostic-card">
                <h3>PHP Information</h3>
                <p>Visa detaljerad information om PHP-installationen, konfiguration och tillgängliga moduler. Teknisk information för systemadministratörer.</p>
                <a href="phpinfo.php" class="diagnostic-button" target="_blank">
                    Visa PHP-info
                </a>
            </div>
        </div>
    </div>
</body>
</html>
