<?php
// Temporarily disable admin_guard to test if it causes corruption
// require_once __DIR__ . '/admin_guard.php';

// Get the requested file
$filename = $_GET['file'] ?? '';

if (empty($filename)) {
    http_response_code(400);
    echo 'No file specified';
    exit;
}

// Sanitize filename to prevent directory traversal
$filename = basename($filename);
$filePath = __DIR__ . '/../downloads/' . $filename;

// Check if file exists
if (!file_exists($filePath)) {
    http_response_code(404);
    echo 'File not found';
    exit;
}

// Set headers for download
header('Content-Type: application/zip');
header('Content-Disposition: attachment; filename="' . $filename . '"');
header('Content-Length: ' . filesize($filePath));
header('Cache-Control: no-cache, must-revalidate');
header('Expires: Sat, 26 Jul 1997 05:00:00 GMT');
header('Content-Transfer-Encoding: binary');

// Output file
readfile($filePath);
?>
