<?php
require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../../security.php';

setSecurityHeaders();
require_once __DIR__ . '/../admin_guard.php';

// admin_guard.php sätter redan $userId, men vi behöver den för JavaScript
// Om den inte är satt, försök hämta från GET eller session
if (!isset($userId) || empty($userId)) {
    $userId = $_GET['user_id'] ?? $_SESSION['user_id'] ?? '';
}
?>
<!DOCTYPE html>
<html lang="sv">
<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width,initial-scale=1" />
    <title>Extern partner - ByggArkiv</title>
    <link rel="stylesheet" href="../common.css">
    <style>
        .modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0,0,0,0.5);
            align-items: center;
            justify-content: center;
        }
        .modal-content {
            background: white;
            border-radius: 12px;
            padding: 30px;
            max-width: 500px;
            width: 90%;
            max-height: 90vh;
            overflow-y: auto;
        }
        .btn {
            margin-right: 10px;
            margin-bottom: 10px;
        }
        .content-wrapper {
            background: white;
            border-radius: 12px;
            padding: 20px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            margin-top: 20px;
        }
        .company-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 16px;
            background: #f8f9fa;
            border: 1px solid #e9ecef;
            border-radius: 8px;
            margin-bottom: 12px;
            transition: all 0.2s;
        }
        .company-item:hover {
            background: #e9ecef;
            border-color: #1a73e8;
        }
        .company-item.highlighted {
            background: #fff3cd;
            border-color: #ffc107;
            border-width: 2px;
            box-shadow: 0 0 0 3px rgba(255, 193, 7, 0.25);
        }
        .company-info {
            flex: 1;
        }
        .company-name {
            font-size: 16px;
            font-weight: 500;
            color: #333;
            margin-bottom: 4px;
        }
        .company-id {
            font-size: 12px;
            color: #666;
            margin-bottom: 4px;
        }
        .company-details {
            font-size: 12px;
            color: #666;
            margin-top: 4px;
            line-height: 1.4;
        }
        .company-detail-item {
            margin-bottom: 2px;
        }
        .company-actions {
            display: flex;
            gap: 8px;
        }
        .users-modal {
            display: none;
            position: fixed;
            z-index: 1001;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0,0,0,0.5);
            align-items: center;
            justify-content: center;
        }
        .users-modal-content {
            background: white;
            border-radius: 12px;
            padding: 30px;
            max-width: 600px;
            width: 90%;
            max-height: 80vh;
            overflow-y: auto;
        }
        .users-modal-title {
            font-size: 20px;
            font-weight: 600;
            color: #333;
            margin-bottom: 20px;
        }
        .user-item {
            padding: 12px;
            background: #f8f9fa;
            border: 1px solid #e9ecef;
            border-radius: 8px;
            margin-bottom: 8px;
        }
        .user-item.inactive {
            background: #ffe0e0;
            border-color: #ffb3b3;
        }
        .user-name {
            font-size: 16px;
            font-weight: 500;
            color: #333;
            margin-bottom: 4px;
        }
        .user-details {
            font-size: 14px;
            color: #666;
        }
        .user-detail-item {
            margin-bottom: 2px;
        }
        .no-users {
            color: #666;
            font-style: italic;
            text-align: center;
            padding: 20px;
        }
    </style>
</head>
<body>
    <div class="container">
        <header class="header">
            <a href="../../index.html<?= !empty($userId) ? '?user_id=' . htmlspecialchars($userId) : '' ?>">
                <img src="../../data/logo.png" alt="ByggArkiv Snickare Stefan" class="logo">
            </a>
            <div class="back-link" style="margin-top: 15px;">
                <a href="../admin.php<?= !empty($userId) ? '?user_id=' . htmlspecialchars($userId) : '' ?>">← Tillbaka till admin</a>
            </div>
        </header>
        
        <div class="content-wrapper">
            <h1 style="color: #1a73e8; text-align: left; margin-top: 0; margin-bottom: 20px;">Extern partner</h1>
            <p style="color: #666; font-size: 14px; margin-bottom: 20px; line-height: 1.6;">
                Här kan du hantera externa partners som kan kopplas till externa användare. Lägg till nya partners, redigera deras namn eller ta bort dem.
            </p>
            
            <button class="btn btn-primary" onclick="showAddModal()">Lägg till</button>
            
            <div id="companiesList" style="margin-top: 20px;">
                <p>Laddar...</p>
            </div>
        </div>
    </div>
    
    <!-- Modal för att lägga till/redigera -->
    <div id="editModal" class="modal">
        <div class="modal-content">
            <h2 id="modalTitle">Lägg till</h2>
            <form id="companyForm">
                <input type="hidden" id="editId" name="id">
                
                <div class="form-group">
                    <label for="name">Partnernamn *</label>
                    <input type="text" id="name" name="name" required>
                </div>
                
                <div class="form-group">
                    <label for="visit_address">Besöksadress</label>
                    <input type="text" id="visit_address" name="visit_address">
                </div>
                
                <div class="form-group">
                    <label for="postal_address">Postadress</label>
                    <input type="text" id="postal_address" name="postal_address">
                </div>
                
                <div class="form-group">
                    <label for="phone">Växelnummer</label>
                    <input type="text" id="phone" name="phone">
                </div>
                
                <div class="form-group">
                    <label for="contact_person">Kontaktperson</label>
                    <input type="text" id="contact_person" name="contact_person">
                </div>
                
                <div class="form-actions" style="display: flex; gap: 8px; justify-content: flex-end;">
                    <button type="submit" class="admin-button btn-primary" style="min-width: auto; padding: 8px 16px;">Spara</button>
                    <button type="button" class="admin-button" onclick="closeModal()" style="min-width: auto; padding: 8px 16px;">Avbryt</button>
                </div>
            </form>
        </div>
    </div>
    
    <!-- Modal för att visa användare kopplade till företag -->
    <div id="usersModal" class="users-modal">
        <div class="users-modal-content">
            <div class="users-modal-title" id="usersModalTitle">Användare kopplade till partner</div>
            <div id="usersList">
                <p>Laddar...</p>
            </div>
            <div style="display: flex; justify-content: flex-end; margin-top: 20px;">
                <button type="button" class="admin-button" onclick="closeUsersModal()" style="min-width: auto; padding: 8px 16px;">Stäng</button>
            </div>
        </div>
    </div>
    
    <script>
        const userId = '<?= htmlspecialchars($userId ?? '') ?>';
        
        // Hämta company_id från URL om det finns
        const urlParams = new URLSearchParams(window.location.search);
        const targetCompanyId = urlParams.get('company_id');
        
        // Ladda företag
        async function loadCompanies() {
            try {
                const response = await fetch(`../../api/chat/external_staff.php?action=list_companies&user_id=${encodeURIComponent(userId)}`);
                const data = await response.json();
                
                const companiesList = document.getElementById('companiesList');
                
                if (data.success && data.companies && data.companies.length > 0) {
                    companiesList.innerHTML = '';
                    
                    data.companies.forEach(company => {
                        const companyDiv = document.createElement('div');
                        const isTarget = targetCompanyId && company.id === targetCompanyId;
                        companyDiv.className = 'company-item' + (isTarget ? ' highlighted' : '');
                        // Använd company.id direkt för ID (säkert eftersom det kommer från API)
                        companyDiv.id = 'company-' + company.id.replace(/[^a-zA-Z0-9_-]/g, '_');
                        const details = [];
                        if (company.phone) details.push(`Växel: ${escapeHtml(company.phone)}`);
                        if (company.contact_person) details.push(`Kontaktperson: ${escapeHtml(company.contact_person)}`);
                        
                        companyDiv.innerHTML = `
                            <div class="company-info">
                                <div class="company-name">${escapeHtml(company.name || '')}</div>
                                ${details.length > 0 ? `<div class="company-details">${details.map(d => `<div class="company-detail-item">${d}</div>`).join('')}</div>` : ''}
                            </div>
                            <div class="company-actions">
                                <button class="action-btn btn-users" onclick="showCompanyUsers('${escapeHtml(company.id)}', '${escapeHtml(company.name || '')}')" title="Visa användare kopplade till denna partner">
                                    <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                                        <path d="M16 11c1.66 0 2.99-1.34 2.99-3S17.66 5 16 5c-1.66 0-3 1.34-3 3s1.34 3 3 3zm-8 0c1.66 0 2.99-1.34 2.99-3S9.66 5 8 5C6.34 5 5 6.34 5 8s1.34 3 3 3zm0 2c-2.33 0-7 1.17-7 3.5V19h14v-2.5c0-2.33-4.67-3.5-7-3.5zm8 0c-.29 0-.62.02-.97.05 1.16.84 1.97 1.97 1.97 3.45V19h6v-2.5c0-2.33-4.67-3.5-7-3.5z"/>
                                    </svg>
                                </button>
                                <button class="action-btn btn-edit" onclick="editCompany('${escapeHtml(company.id)}', '${escapeHtml(company.name || '')}', '${escapeHtml(company.visit_address || '')}', '${escapeHtml(company.postal_address || '')}', '${escapeHtml(company.phone || '')}', '${escapeHtml(company.contact_person || '')}')" title="Redigera extern partner">
                                    <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                                        <path d="M3 17.25V21h3.75L17.81 9.94l-3.75-3.75L3 17.25zM20.71 7.04c.39-.39.39-1.02 0-1.41l-2.34-2.34c-.39-.39-1.02-.39-1.41 0l-1.83 1.83 3.75 3.75 1.83-1.83z"/>
                                    </svg>
                                </button>
                                <button class="action-btn btn-delete" onclick="deleteCompany('${escapeHtml(company.id)}', '${escapeHtml(company.name || '')}')" title="Ta bort extern partner">
                                    <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                                        <path d="M6 19c0 1.1.9 2 2 2h8c1.1 0 2-.9 2-2V7H6v12zM19 4h-3.5l-1-1h-5l-1 1H5v2h14V4z"/>
                                    </svg>
                                </button>
                            </div>
                        `;
                        companiesList.appendChild(companyDiv);
                    });
                    
                    // Scrolla till det markerade företaget om det finns
                    if (targetCompanyId) {
                        setTimeout(() => {
                            // Sanitize company_id för att matcha det ID som sattes i HTML
                            const sanitizedCompanyId = targetCompanyId.replace(/[^a-zA-Z0-9_-]/g, '_');
                            const targetElement = document.getElementById('company-' + sanitizedCompanyId);
                            if (targetElement) {
                                targetElement.scrollIntoView({ behavior: 'smooth', block: 'center' });
                            } else {
                                console.warn('Kunde inte hitta företag med ID:', targetCompanyId);
                            }
                        }, 100);
                    }
                } else {
                    companiesList.innerHTML = '<p style="color: #666; font-style: italic;">Inga externa partners registrerade ännu.</p>';
                }
            } catch (error) {
                console.error('Fel vid laddning av externa partners:', error);
                document.getElementById('companiesList').innerHTML = '<p style="color: #dc3545;">Fel vid laddning av externa partners</p>';
            }
        }
        
        function escapeHtml(text) {
            const div = document.createElement('div');
            div.textContent = text;
            return div.innerHTML;
        }
        
        function showAddModal() {
            document.getElementById('modalTitle').textContent = 'Lägg till';
            document.getElementById('editId').value = '';
            document.getElementById('name').value = '';
            document.getElementById('visit_address').value = '';
            document.getElementById('postal_address').value = '';
            document.getElementById('phone').value = '';
            document.getElementById('contact_person').value = '';
            document.getElementById('editModal').style.display = 'flex';
        }
        
        function editCompany(id, name, visitAddress, postalAddress, phone, contactPerson) {
            document.getElementById('modalTitle').textContent = 'Redigera extern partner';
            document.getElementById('editId').value = id;
            document.getElementById('name').value = name || '';
            document.getElementById('visit_address').value = visitAddress || '';
            document.getElementById('postal_address').value = postalAddress || '';
            document.getElementById('phone').value = phone || '';
            document.getElementById('contact_person').value = contactPerson || '';
            document.getElementById('editModal').style.display = 'flex';
        }
        
        function closeModal() {
            document.getElementById('editModal').style.display = 'none';
        }
        
        // Hantera formulär
        document.getElementById('companyForm').addEventListener('submit', async (e) => {
            e.preventDefault();
            
            const id = document.getElementById('editId').value;
            const name = document.getElementById('name').value.trim();
            const visitAddress = document.getElementById('visit_address').value.trim();
            const postalAddress = document.getElementById('postal_address').value.trim();
            const phone = document.getElementById('phone').value.trim();
            const contactPerson = document.getElementById('contact_person').value.trim();
            
            if (!name) {
                alert('Partnernamn krävs');
                return;
            }
            
            try {
                const formData = new FormData();
                formData.append('action', id ? 'update_company' : 'add_company');
                formData.append('user_id', userId);
                if (id) {
                    formData.append('id', id);
                }
                formData.append('name', name);
                formData.append('visit_address', visitAddress);
                formData.append('postal_address', postalAddress);
                formData.append('phone', phone);
                formData.append('contact_person', contactPerson);
                
                const response = await fetch('../../api/chat/external_staff.php', {
                    method: 'POST',
                    body: formData
                });
                
                const data = await response.json();
                
                if (data.success) {
                    closeModal();
                    await loadCompanies();
                } else {
                    alert('Fel: ' + data.message);
                }
            } catch (error) {
                console.error('Fel vid sparande:', error);
                alert('Ett fel uppstod');
            }
        });
        
        function deleteCompany(id, name) {
            if (!confirm(`Är du säker på att du vill ta bort den externa partnern "${name}"?`)) {
                return;
            }
            
            const formData = new FormData();
            formData.append('action', 'delete_company');
            formData.append('user_id', userId);
            formData.append('id', id);
            
            fetch('../../api/chat/external_staff.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    loadCompanies();
                } else {
                    alert('Fel: ' + data.message);
                }
            })
            .catch(error => {
                console.error('Fel vid borttagning:', error);
                alert('Ett fel uppstod');
            });
        }
        
        async function showCompanyUsers(companyId, companyName) {
            document.getElementById('usersModalTitle').textContent = `Användare kopplade till: ${escapeHtml(companyName)}`;
            document.getElementById('usersList').innerHTML = '<p>Laddar...</p>';
            document.getElementById('usersModal').style.display = 'flex';
            
            try {
                const response = await fetch(`../../api/chat/external_staff.php?action=get_company_users&company_id=${encodeURIComponent(companyId)}&user_id=${encodeURIComponent(userId)}`);
                const data = await response.json();
                
                const usersList = document.getElementById('usersList');
                
                if (data.success && data.users && data.users.length > 0) {
                    usersList.innerHTML = '';
                    
                    // Sortera användare: aktiva först, inaktiva sist
                    const sortedUsers = [...data.users].sort((a, b) => {
                        const aActive = a.active !== false && a.active !== 0 && a.active !== '0' && a.active !== 'false';
                        const bActive = b.active !== false && b.active !== 0 && b.active !== '0' && b.active !== 'false';
                        if (aActive === bActive) return 0;
                        return aActive ? -1 : 1;
                    });
                    
                    sortedUsers.forEach(user => {
                        const userDiv = document.createElement('div');
                        const isActive = user.active !== false && user.active !== 0 && user.active !== '0' && user.active !== 'false';
                        userDiv.className = 'user-item' + (isActive ? '' : ' inactive');
                        
                        const details = [];
                        if (user.type_name) details.push(`Yrkesroll: ${escapeHtml(user.type_name)}`);
                        if (user.email) details.push(`E-post: ${escapeHtml(user.email)}`);
                        if (user.phone) details.push(`Telefon: ${escapeHtml(user.phone)}`);
                        if (!isActive) details.push(`Status: Inaktiv`);
                        
                        userDiv.innerHTML = `
                            <div class="user-name">${escapeHtml(user.name || user.full_name || 'Okänd')}</div>
                            ${details.length > 0 ? `<div class="user-details">${details.map(d => `<div class="user-detail-item">${d}</div>`).join('')}</div>` : ''}
                        `;
                        usersList.appendChild(userDiv);
                    });
                } else {
                    usersList.innerHTML = '<div class="no-users">Inga användare kopplade till denna partner.</div>';
                }
            } catch (error) {
                console.error('Fel vid laddning av användare:', error);
                document.getElementById('usersList').innerHTML = '<p style="color: #dc3545;">Fel vid laddning av användare</p>';
            }
        }
        
        function closeUsersModal() {
            document.getElementById('usersModal').style.display = 'none';
        }
        
        // Stäng modal när man klickar utanför
        document.getElementById('editModal').addEventListener('click', function(e) {
            if (e.target === this) {
                closeModal();
            }
        });
        
        document.getElementById('usersModal').addEventListener('click', function(e) {
            if (e.target === this) {
                closeUsersModal();
            }
        });
        
        // Ladda företag när sidan laddas
        loadCompanies();
    </script>
</body>
</html>

