<?php
// Definiera UPLOAD_ROOT direkt här istället för att använda config.php
define('UPLOAD_ROOT', __DIR__ . '/../../uploads');

// Svara alltid JSON
header('Content-Type: application/json; charset=utf-8');

// Validera fält
$fileName = $_POST['fileName'] ?? '';
$projectId = $_POST['projectId'] ?? '';

if ($fileName === '' || $projectId === '') {
  http_response_code(400);
  echo json_encode(['ok' => false, 'error' => 'Saknade parametrar.']);
  exit;
}

// Säkerhetskontroll - projekt-ID får bara innehålla alfanumeriska tecken och bindestreck
if (!preg_match('/^[a-zA-Z0-9-]+$/', $projectId)) {
  http_response_code(400);
  echo json_encode(['ok' => false, 'error' => 'Ogiltigt projekt-ID.']);
  exit;
}

// Säkerhetskontroll - filnamn får bara innehålla alfanumeriska tecken, bindestreck, understreck och punkter
if (!preg_match('/^[a-zA-Z0-9._-]+$/', $fileName)) {
  http_response_code(400);
  echo json_encode(['ok' => false, 'error' => 'Ogiltigt filnamn.']);
  exit;
}

// Bygg sökvägar
$projectDir = UPLOAD_ROOT . '/' . $projectId;
$documentPath = $projectDir . '/' . $fileName;
$metadataPath = $projectDir . '/' . pathinfo($fileName, PATHINFO_FILENAME) . '.json';

// Kontrollera att filerna finns i rätt projektmapp (säkerhetskontroll)
$uploadRoot = rtrim(UPLOAD_ROOT, '/\\');
$realDocumentPath = realpath($documentPath);
$realMetadataPath = realpath($metadataPath);
$realUploadRoot = realpath($uploadRoot);

if (!$realDocumentPath || !$realUploadRoot ||
    !str_starts_with($realDocumentPath, $realUploadRoot) || 
    ($realMetadataPath && !str_starts_with($realMetadataPath, $realUploadRoot))) {
  // Logga path traversal-försök
  require_once __DIR__ . '/../../security.php';
  $userId = $_POST['user_id'] ?? $_GET['user_id'] ?? 'unknown';
  logSecurityEvent('path_traversal_attempt', [
    'attempted_path' => $documentPath,
    'resolved_path' => $realDocumentPath ?: null,
    'upload_root' => $realUploadRoot,
    'reason' => 'path_outside_allowed_directory'
  ], 'high', $userId, $projectId, 'delete_document');
  
  http_response_code(403);
  echo json_encode([
    'ok' => false, 
    'error' => 'Otillåten filväg.'
  ]);
  exit;
}

// Ta bort filer
$success = true;
$errors = [];

// Ta bort dokumentfil
if (file_exists($documentPath)) {
  if (!unlink($documentPath)) {
    $success = false;
    $errors[] = 'Kunde inte ta bort dokumentfil.';
  }
} else {
  $errors[] = 'Dokumentfil finns inte.';
}

// Ta bort metadatafil (om den finns)
if (file_exists($metadataPath)) {
  if (!unlink($metadataPath)) {
    $success = false;
    $errors[] = 'Kunde inte ta bort metadatafil.';
  }
}
// Metadatafil är valfri, så vi loggar inte fel om den inte finns

if (!$success) {
  http_response_code(500);
  echo json_encode(['ok' => false, 'error' => implode(' ', $errors)]);
  exit;
}

echo json_encode(['ok' => true, 'message' => 'Dokument borttaget.']);
?>
