<?php
// Svara alltid JSON
header('Content-Type: application/json; charset=utf-8');

// Definiera UPLOAD_ROOT direkt här istället för att använda config.php
define('UPLOAD_ROOT', __DIR__ . '/../../uploads');

// Auth removed - no password required for admin interface

// Validera fält
$imagePath = $_POST['imagePath'] ?? '';
$jsonPath = $_POST['jsonPath'] ?? '';

if ($imagePath === '' || $jsonPath === '') {
  http_response_code(400);
  echo json_encode(['ok' => false, 'error' => 'Saknade filvägar.']);
  exit;
}

// Säkerställ att filerna finns i uploads-mappen (säkerhetskontroll)
$uploadRoot = rtrim(UPLOAD_ROOT, '/\\');
if (!str_starts_with(realpath($imagePath), realpath($uploadRoot)) || 
    !str_starts_with(realpath($jsonPath), realpath($uploadRoot))) {
  http_response_code(403);
  echo json_encode(['ok' => false, 'error' => 'Otillåten filväg.']);
  exit;
}

// Beräkna ev. tumnagelväg (<basename>-thumb.jpg)
$thumbPath = preg_replace('/\.(jpg|jpeg|png|webp|heic|heif)$/i', '', $imagePath) . '-thumb.jpg';

// Ta bort filerna permanent
$success = true;
$errors = [];

if (file_exists($imagePath)) {
  if (!unlink($imagePath)) {
    $success = false;
    $errors[] = 'Kunde inte ta bort bildfil.';
  }
} else {
  $errors[] = 'Bildfil finns inte.';
}

// Ta bort tumnagel om den finns
if (file_exists($thumbPath)) {
  if (!unlink($thumbPath)) {
    $success = false;
    $errors[] = 'Kunde inte ta bort tumnagel.';
  }
}

if (file_exists($jsonPath)) {
  if (!unlink($jsonPath)) {
    $success = false;
    $errors[] = 'Kunde inte ta bort JSON-fil.';
  }
} else {
  $errors[] = 'JSON-fil finns inte.';
}

if (!$success) {
  http_response_code(500);
  echo json_encode(['ok' => false, 'error' => implode(' ', $errors)]);
  exit;
}

echo json_encode(['ok' => true, 'message' => 'Filer har tagits bort permanent.']);
