<?php
require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../../security.php';

setSecurityHeaders();
header('Content-Type: application/json; charset=utf-8');

$projectId = sanitizeInput($_GET['project_id'] ?? '', 'project_id');
if ($projectId === '') {
    http_response_code(400);
    echo json_encode(['ok' => false, 'error' => 'project_id saknas']);
    exit;
}

// Hantera arkiverade projekt
if ($projectId === 'archived') {
    // Hämta alla arkiverade projekt och visa deras filer
    $projectsFile = __DIR__ . '/../../data/projects.json';
    $projects = [];
    if (file_exists($projectsFile)) {
        $content = file_get_contents($projectsFile);
        $projects = json_decode($content, true) ?: [];
    }
    
    $archivedProjects = array_filter($projects, function($project) {
        return ($project['status'] ?? 'active') === 'archived';
    });
    
    $allFiles = [];
    foreach ($archivedProjects as $project) {
        $projectDir = __DIR__ . '/../../' . rtrim(UPLOAD_ROOT, '/\\') . DIRECTORY_SEPARATOR . basename($project['id']);
        if (is_dir($projectDir)) {
            $entries = scandir($projectDir) ?: [];
            foreach ($entries as $entry) {
                if ($entry === '.' || $entry === '..') continue;
                $fullPath = $projectDir . DIRECTORY_SEPARATOR . $entry;
                if (!is_file($fullPath)) continue;
                
                $ext = strtolower(pathinfo($entry, PATHINFO_EXTENSION));
                if (in_array($ext, ['jpg', 'jpeg', 'png', 'webp', 'heic', 'heif'], true)) continue;
                if (str_ends_with($entry, '-thumb.jpg')) continue;
                if ($ext === 'json') continue;
                if ($ext === 'finfo') continue;
                
                $metaPath = preg_replace('/\.[^.]+$/', '', $fullPath) . '.finfo';
                $meta = [];
                if (is_file($metaPath)) {
                    $metaRaw = file_get_contents($metaPath);
                    $meta = json_decode($metaRaw, true) ?: [];
                }
                
                $storedAt = $meta['stored_at'] ?? date('c', @filemtime($fullPath) ?: time());
                
                $allFiles[] = [
                    'name' => $entry,
                    'path' => $fullPath,
                    'url' => '../view_file.php?project_id=' . urlencode($project['id']) . '&file=' . urlencode($entry),
                    'bytes' => @filesize($fullPath) ?: 0,
                    'stored_at' => $storedAt,
                    'note' => $meta['note'] ?? '',
                    'mime' => $meta['mime'] ?? null,
                    'original' => $meta['original'] ?? $entry,
                    'meta_file' => is_file($metaPath) ? basename($metaPath) : null,
                    'is_archived' => true,
                    'project_name' => $project['name'],
                    'project_id' => $project['id']
                ];
            }
        }
    }
    
    // Sortera nyast först
    usort($allFiles, function($a, $b) {
        return strtotime($b['stored_at']) <=> strtotime($a['stored_at']);
    });
    
    echo json_encode(['ok' => true, 'files' => $allFiles], JSON_UNESCAPED_UNICODE);
    exit;
} else {
    $projectDir = __DIR__ . '/../../' . rtrim(UPLOAD_ROOT, '/\\') . DIRECTORY_SEPARATOR . basename($projectId);
    if (!is_dir($projectDir)) {
        echo json_encode(['ok' => true, 'files' => []]);
        exit;
    }
}

// Bildformat att filtrera bort från dokumentlistan
$imageExts = ['jpg','jpeg','png','webp','heic','heif'];

$entries = scandir($projectDir) ?: [];
$files = [];

foreach ($entries as $entry) {
    if ($entry === '.' || $entry === '..') continue;
    $fullPath = $projectDir . DIRECTORY_SEPARATOR . $entry;
    if (!is_file($fullPath)) continue;

    $ext = strtolower(pathinfo($entry, PATHINFO_EXTENSION));

    // Hoppa över bildfiler, thumbnails och bild-metadata
    if (in_array($ext, $imageExts, true)) continue;
    if (str_ends_with($entry, '-thumb.jpg')) continue;
    if ($ext === 'json') continue;

    // Hoppa över metadatafilerna (.finfo) i huvudlistan; de knyts till sin fil
    if ($ext === 'finfo') continue;

    // För dokument (t.ex. pdf, txt)
    $metaPath = preg_replace('/\.[^.]+$/', '', $fullPath) . '.finfo';
    $meta = [];
    if (is_file($metaPath)) {
        $metaRaw = file_get_contents($metaPath);
        $meta = json_decode($metaRaw, true) ?: [];
    }

    // Använd stored_at från metadata, annars filemtime
    $storedAt = $meta['stored_at'] ?? date('c', @filemtime($fullPath) ?: time());
    
    $files[] = [
        'name' => $entry,
        'path' => $fullPath,
        'url' => '../view_file.php?project_id=' . urlencode($projectId) . '&file=' . urlencode($entry),
        'bytes' => @filesize($fullPath) ?: 0,
        'stored_at' => $storedAt,
        'note' => $meta['note'] ?? '',
        'mime' => $meta['mime'] ?? null,
        'original' => $meta['original'] ?? $entry,
        'meta_file' => is_file($metaPath) ? basename($metaPath) : null,
    ];
}

// Sortera nyast först
usort($files, function($a, $b) {
    return strtotime($b['stored_at']) <=> strtotime($a['stored_at']);
});

echo json_encode(['ok' => true, 'files' => $files], JSON_UNESCAPED_UNICODE);


