<?php
require_once __DIR__ . '/../config.php';

// Svara alltid JSON
header('Content-Type: application/json; charset=utf-8');

// Auth removed - no password required for admin interface

// Validera fält
$imagePath = $_POST['imagePath'] ?? '';
$jsonPath = $_POST['jsonPath'] ?? '';
$targetProjectId = $_POST['targetProjectId'] ?? '';

if ($imagePath === '' || $jsonPath === '' || $targetProjectId === '') {
  http_response_code(400);
  echo json_encode(['ok' => false, 'error' => 'Saknade parametrar.']);
  exit;
}

// Säkerställ att filerna finns i attic-mappen (säkerhetskontroll)
$uploadRoot = __DIR__ . '/../../' . rtrim(UPLOAD_ROOT, '/\\');
$atticDir = $uploadRoot . '/attic';
$realImagePath = realpath($imagePath);
$realJsonPath = realpath($jsonPath);
$realAtticDir = realpath($atticDir);

if (!$realImagePath || !$realJsonPath || !$realAtticDir ||
    !str_starts_with($realImagePath, $realAtticDir) || 
    !str_starts_with($realJsonPath, $realAtticDir)) {
  // Logga path traversal-försök
  require_once __DIR__ . '/../../security.php';
  $userId = $_POST['user_id'] ?? $_GET['user_id'] ?? 'unknown';
  logSecurityEvent('path_traversal_attempt', [
    'attempted_image_path' => $imagePath,
    'attempted_json_path' => $jsonPath,
    'resolved_image_path' => $realImagePath ?: null,
    'resolved_json_path' => $realJsonPath ?: null,
    'attic_dir' => $realAtticDir,
    'reason' => 'path_outside_attic_directory'
  ], 'high', $userId, $targetProjectId, 'restore_file');
  
  http_response_code(403);
  echo json_encode(['ok' => false, 'error' => 'Filerna måste vara i attic-mappen.']);
  exit;
}

// Kontrollera att målprojektet finns
$targetProjectDir = $uploadRoot . '/' . $targetProjectId;
if (!is_dir($targetProjectDir)) {
  http_response_code(400);
  echo json_encode(['ok' => false, 'error' => 'Målprojekt finns inte.']);
  exit;
}

// Hämta originalfilnamn (ta bort timestamp-prefix)
$imageBasename = basename($imagePath);
$jsonBasename = basename($jsonPath);

// Ta bort timestamp-prefix (format: YYYYMMDD_HHMMSS_originalfilename)
$originalImageName = preg_replace('/^\d{8}_\d{6}_/', '', $imageBasename);
$originalJsonName = preg_replace('/^\d{8}_\d{6}_/', '', $jsonBasename);

// Beräkna ev. tumnagelväg
$thumbPath = preg_replace('/\.(jpg|jpeg|png|webp|heic|heif)$/i', '', $imagePath) . '-thumb.jpg';
$thumbBasename = basename($thumbPath);
$originalThumbName = preg_replace('/^\d{8}_\d{6}_/', '', $thumbBasename);

// Nya sökvägar i målprojektet
$newImagePath = $targetProjectDir . '/' . $originalImageName;
$newJsonPath = $targetProjectDir . '/' . $originalJsonName;
$newThumbPath = $targetProjectDir . '/' . $originalThumbName;

// Kontrollera om filnamnet redan finns i målprojektet
if (file_exists($newImagePath) || file_exists($newJsonPath)) {
  // Lägg till timestamp för att undvika konflikter
  $timestamp = date('Ymd_His');
  $pathInfo = pathinfo($originalImageName);
  $baseName = $pathInfo['filename'];
  $extension = isset($pathInfo['extension']) ? '.' . $pathInfo['extension'] : '';
  
  $newImagePath = $targetProjectDir . '/' . $baseName . '_restored_' . $timestamp . $extension;
  $newJsonPath = $targetProjectDir . '/' . $baseName . '_restored_' . $timestamp . '.json';
  $newThumbPath = $targetProjectDir . '/' . $baseName . '_restored_' . $timestamp . '-thumb.jpg';
}

// Flytta filerna tillbaka
$success = true;
$errors = [];

// Flytta bildfilen
if (file_exists($imagePath)) {
  if (!rename($imagePath, $newImagePath)) {
    $success = false;
    $errors[] = 'Kunde inte flytta bildfil.';
  }
} else {
  $errors[] = 'Bildfil finns inte i attic.';
}

// Flytta JSON-filen
if (file_exists($jsonPath)) {
  if (!rename($jsonPath, $newJsonPath)) {
    $success = false;
    $errors[] = 'Kunde inte flytta JSON-fil.';
  }
  
  // Uppdatera project_id i JSON-filen
  if ($success) {
    $jsonContent = file_get_contents($newJsonPath);
    $metadata = json_decode($jsonContent, true);
    if ($metadata) {
      $metadata['project_id'] = $targetProjectId;
      $metadata['restored_at'] = date('Y-m-d H:i:s');
      if (!file_put_contents($newJsonPath, json_encode($metadata, JSON_PRETTY_PRINT))) {
        $errors[] = 'Kunde inte uppdatera JSON-metadata.';
      }
    }
  }
} else {
  $errors[] = 'JSON-fil finns inte i attic.';
}

// Flytta tumnagel om den finns
if (file_exists($thumbPath)) {
  if (!rename($thumbPath, $newThumbPath)) {
    // Detta är inte kritiskt, så vi loggar bara varningen
    $errors[] = 'Varning: Kunde inte flytta tumnagel.';
  }
}

if (!$success) {
  http_response_code(500);
  echo json_encode(['ok' => false, 'error' => implode(' ', $errors)]);
  exit;
}

// Försök hitta projektnamnet
$projectName = $targetProjectId;
$projectsFile = __DIR__ . '/../data/projects.json';
if (file_exists($projectsFile)) {
  $projectsData = json_decode(file_get_contents($projectsFile), true);
  if ($projectsData) {
    foreach ($projectsData as $project) {
      if ($project['id'] === $targetProjectId) {
        $projectName = $project['name'];
        // Ta bort projekt-ID prefix om det finns
        if (str_starts_with($projectName, $targetProjectId . ' – ')) {
          $projectName = substr($projectName, strlen($targetProjectId . ' – '));
        }
        break;
      }
    }
  }
}

echo json_encode([
  'ok' => true, 
  'message' => 'Bild återställd till projekt "' . $projectName . '"',
  'newImagePath' => $newImagePath,
  'newJsonPath' => $newJsonPath,
  'newThumbPath' => file_exists($newThumbPath) ? $newThumbPath : null,
  'targetProjectId' => $targetProjectId,
  'projectName' => $projectName,
  'newImageFileName' => basename($newImagePath),
  'newJsonFileName' => basename($newJsonPath)
]);
