<?php
require_once __DIR__ . '/../admin_guard.php';
require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../../security.php';

setSecurityHeaders();
header('Content-Type: application/json; charset=utf-8');

// Endast POST tillåten
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['ok' => false, 'error' => 'Endast POST tillåten']);
    exit;
}

// Validera input
$projectId = sanitizeInput($_POST['project_id'] ?? '', 'project_id');
$note = sanitizeInput($_POST['note'] ?? '', 'string');

if (empty($projectId)) {
    echo json_encode(['ok' => false, 'error' => 'Projekt-ID krävs']);
    exit;
}

// Kontrollera att fil finns
if (!isset($_FILES['file']) || $_FILES['file']['error'] !== UPLOAD_ERR_OK) {
    echo json_encode(['ok' => false, 'error' => 'Ingen fil uppladdad eller uppladdningsfel']);
    exit;
}

$file = $_FILES['file'];

// Validera MIME-typ (endast PDF och TXT enligt files.html)
$finfo = new finfo(FILEINFO_MIME_TYPE);
$mimeType = $finfo->file($file['tmp_name']);

global $ALLOWED_DOCUMENT_MIME;
if (!isset($ALLOWED_DOCUMENT_MIME[$mimeType])) {
    echo json_encode(['ok' => false, 'error' => 'Otillåten filtyp. Endast PDF och TXT tillåtna.']);
    exit;
}

// Validera filstorlek
if ($file['size'] > MAX_FILE_BYTES) {
    $fileSizeMB = round($file['size'] / (1024 * 1024), 1);
    $maxSizeMB = MAX_FILE_BYTES / (1024 * 1024);
    echo json_encode(['ok' => false, 'error' => "Filen är för stor: {$fileSizeMB} MB (max {$maxSizeMB} MB)"]);
    exit;
}

// Skapa projektmapp om den inte finns
$projectDir = __DIR__ . '/../../' . rtrim(UPLOAD_ROOT, '/\\') . DIRECTORY_SEPARATOR . basename($projectId);
if (!is_dir($projectDir)) {
    mkdir($projectDir, 0755, true);
}

// Generera säkert filnamn
$originalName = $file['name'];
$extension = pathinfo($originalName, PATHINFO_EXTENSION);
$safeName = preg_replace('/[^a-zA-Z0-9._-]/', '_', basename($originalName, '.' . $extension));
$timestamp = date('Ymd_His');
$finalName = $safeName . '_' . $timestamp . '.' . $extension;
$targetPath = $projectDir . DIRECTORY_SEPARATOR . $finalName;

// Flytta filen
if (!move_uploaded_file($file['tmp_name'], $targetPath)) {
    echo json_encode(['ok' => false, 'error' => 'Kunde inte spara filen']);
    exit;
}

// Skapa metadata-fil (.finfo)
$metaPath = preg_replace('/\.[^.]+$/', '', $targetPath) . '.finfo';
$metadata = [
    'original' => $originalName,
    'note' => $note,
    'mime' => $mimeType,
    'stored_at' => date('c'),
    'size' => $file['size']
];

file_put_contents($metaPath, json_encode($metadata, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));

echo json_encode(['ok' => true, 'message' => 'Fil uppladdad']);
?>
