<?php
require_once __DIR__ . '/../../lib/data_functions.php';
?>
<link rel="stylesheet" href="../common.css">
<style>
/* Button styles for user_project_view.php */
.view-btn {
    position: absolute;
    top: 8px;
    right: 82px;
    background: white;
    color: #1a73e8;
    border: 2px solid #1a73e8;
    border-radius: 50%;
    width: 30px;
    height: 30px;
    font-size: 16px;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    opacity: 0.9;
    transition: opacity 0.2s;
    z-index: 10;
    pointer-events: auto;
}
.view-btn:hover {
    opacity: 1;
    background: #1a73e8;
    color: white;
}

.move-btn {
    position: absolute;
    top: 8px;
    right: 45px;
    background: white;
    color: #28a745;
    border: 2px solid #28a745;
    border-radius: 50%;
    width: 30px;
    height: 30px;
    font-size: 16px;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    opacity: 0.9;
    transition: opacity 0.2s;
    z-index: 10;
    pointer-events: auto;
}
.move-btn:hover {
    opacity: 1;
    background: #28a745;
    color: white;
}

.delete-btn {
    position: absolute;
    top: 8px;
    right: 8px;
    background: white;
    color: #dc3545;
    border: 2px solid #dc3545;
    border-radius: 50%;
    width: 30px;
    height: 30px;
    font-size: 16px;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    opacity: 0.9;
    transition: opacity 0.2s;
    z-index: 10;
    pointer-events: auto;
}
.delete-btn:hover {
    opacity: 1;
    background: #dc3545;
    color: white;
}

.edit-btn {
    position: absolute;
    top: 8px;
    right: 119px;
    background: white;
    color: #ff9800;
    border: 2px solid #ff9800;
    border-radius: 50%;
    width: 30px;
    height: 30px;
    font-size: 16px;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    opacity: 0.9;
    transition: opacity 0.2s;
    z-index: 10;
    pointer-events: auto;
}
.edit-btn:hover {
    opacity: 1;
    background: #ff9800;
    color: white;
}
</style>
<?php

// Hämta parametrar från URL
$selectedProject = $_GET['project_id'] ?? '';
$selectedUserId = $_GET['filter_user_id'] ?? '';

// Hämta all data
$data = getAllUploadData();
$allUploads = $data['allUploads'];
$projectNames = $data['projectNames'];

// Hämta användardata för att visa namn
$userNames = [];
$userData = [];
if (file_exists(__DIR__ . '/../../data/userids.json')) {
    $userContent = file_get_contents(__DIR__ . '/../../data/userids.json');
    if ($userContent !== false) {
        $userData = json_decode($userContent, true) ?: [];
        foreach ($userData as $user) {
            $userNames[$user['user_id']] = $user['full_name'];
        }
    }
}

// Filtrera bilder som matchar BÅDE projekt OCH användare (AND-operation)
$combinedImages = array_filter($allUploads, function($upload) use ($selectedProject, $selectedUserId) {
    return $upload['project_id'] === $selectedProject && $upload['user_id'] === $selectedUserId;
});

// Sortera efter datum (nyaste först)
usort($combinedImages, function($a, $b) {
    return strtotime($b['stored_at']) - strtotime($a['stored_at']);
});
?>

<div class="results-section">
    <div class="results-header">
        <?php 
        $displayProjectName = $projectNames[$selectedProject] ?? $selectedProject;
        // Ta bort projekt-ID från början om det finns
        if (str_starts_with($displayProjectName, $selectedProject . ' – ')) {
            $displayProjectName = substr($displayProjectName, strlen($selectedProject . ' – '));
        }
        ?>
        <div style="font-size: 18px; font-weight: 600; margin-bottom: 4px;">
            <?= htmlspecialchars($displayProjectName) ?>
        </div>
        <div style="font-size: 14px; opacity: 0.8;">
            Projekt: <?= htmlspecialchars($selectedProject) ?> | <?= htmlspecialchars($userNames[$selectedUserId] ?? $selectedUserId) ?>
            <span style="margin-left: 8px;">(<?= count($combinedImages) ?> filer)</span>
        </div>
    </div>
    <div class="results-content">
        <?php if (empty($combinedImages)): ?>
            <div class="no-results">
                Inga filer hittades som matchar både det valda projektet och användaren.
            </div>
        <?php else: ?>
            <div class="file-grid">
                <?php foreach ($combinedImages as $image): ?>
                    <div class="file-item" 
                         data-project="<?= htmlspecialchars($image['project_id']) ?>"
                         data-project-id="<?= htmlspecialchars($image['project_id']) ?>"
                         data-upload-id="<?= htmlspecialchars($image['upload_id'] ?? '') ?>"
                         data-user-id="<?= htmlspecialchars($image['user_id'] ?? '') ?>"
                         data-image-path="<?= htmlspecialchars($image['image_path']) ?>"
                         data-json-path="<?= htmlspecialchars(str_replace(['.jpg', '.png', '.heic', '.heif', '.mp4', '.webm', '.mov', '.avi'], '.json', $image['image_path'])) ?>"
                         <?php 
                         $uid = $image['user_id'] ?? '';
                         $uname = getUserFullName($uid);
                         $displayUser = $uname !== '' ? $uname : 'Ingen användare';
                         $displayDate = date('Y-m-d H:i', strtotime($image['stored_at']));
                         $filename = basename($image['image_path']);
                         $note = $image['note'] ?? '';
                         $isVideo = ($image['file_type'] ?? 'image') === 'video';
                         $imageNumber = isset($image['image_number']) && is_numeric($image['image_number']) ? (int)$image['image_number'] : null;
                         $imageNumberText = $imageNumber !== null ? ($isVideo ? 'Video #' . $imageNumber : 'Bild #' . $imageNumber) : '';
                         
                         // Generate image_url using view_file.php for security
                         $imageUrl = '../../view_file.php?project_id=' . urlencode($image['project_id']) . '&file=' . urlencode(basename($image['image_path']));
                         
                         $lightboxArgs = [
                             $imageUrl,
                             $filename,
                             $displayDate,
                             $displayUser,
                             $note,
                             $imageNumberText
                         ];
                         ?>
                         data-image-url="<?= htmlspecialchars($imageUrl) ?>"
                         data-full-image-url="<?= htmlspecialchars($imageUrl) ?>"
                         data-filename="<?= htmlspecialchars($filename) ?>"
                         data-date="<?= htmlspecialchars($displayDate) ?>"
                         data-user="<?= htmlspecialchars($displayUser) ?>"
                         data-note="<?= htmlspecialchars($note) ?>"
                         >
                        <div class="file-overlay">
                            <button class="view-btn" onclick='openLightbox.apply(null, <?= json_encode($lightboxArgs, JSON_HEX_QUOT | JSON_HEX_APOS) ?>)' title="Visa fil i full storlek"><img src="../icons/view.svg" width="16" height="16" alt="Visa"></button>
                            <button class="move-btn" onclick="moveFile(this)" title="Flytta till annat projekt"><img src="../icons/move.svg" width="16" height="16" alt="Flytta"></button>
                            <button class="delete-btn" onclick="deleteFile(this)" title="Ta bort fil"><img src="../icons/delete.svg" width="16" height="16" alt="Ta bort"></button>
                            <?php if (empty($image['note'])): ?>
                                <button class="edit-btn" onclick="addDescription(this)" title="Ändra beskrivning"><img src="../icons/edit.svg" width="16" height="16" alt="Redigera"></button>
                            <?php endif; ?>
                        </div>
                        <?php 
                        if ($isVideo): ?>
                            <video class="file-image" 
                                   controls 
                                   preload="metadata"
                                   onclick='openLightbox.apply(null, <?= json_encode($lightboxArgs, JSON_HEX_QUOT | JSON_HEX_APOS) ?>)'>
                                <source src="<?= htmlspecialchars($imageUrl) ?>" type="<?= htmlspecialchars($image['mime'] ?? 'video/mp4') ?>">
                                Din webbläsare stöder inte videouppspelning.
                            </video>
                        <?php else: ?>
                            <img src="<?= htmlspecialchars($image['thumb_url'] ?? $imageUrl) ?>" 
                                 alt="Bild" 
                                 class="file-image"
                                 loading="lazy"
                                 onerror="this.style.display='none'">
                        <?php endif; ?>
                        <div class="file-info">
                            <?php if ($imageNumberText): ?>
                                <div class="file-image-number" style="font-weight: bold; color: #1976d2; margin-bottom: 4px;">
                                    <?= htmlspecialchars($imageNumberText) ?>
                                </div>
                            <?php endif; ?>
                        <?php 
                        $uid = $image['user_id'] ?? '';
                        $uname = getUserFullName($uid);
                        $displayUser = $uname !== '' ? htmlspecialchars($uname) : 'Ingen användare';
                        $displayDate = date('Y-m-d H:i', strtotime($image['stored_at']));
                        $origSizeText = number_format(($image['bytes'] ?? 0) / 1024 / 1024, 1) . 'M';
                        $thumbSizeText = '';
                        if (!empty($image['thumb_path']) && file_exists($image['thumb_path'])) {
                            $thumbBytes = @filesize($image['thumb_path']);
                            if ($thumbBytes !== false) {
                                $thumbSizeText = ' (' . number_format($thumbBytes / 1024, 1) . 'k)';
                            }
                        }
                        ?>
                        <div class="file-meta">
                            <div class="file-meta-row">
                                <span class="file-date"><?= $displayDate ?>    <?= $origSizeText ?><?= $thumbSizeText ?></span>
                                <span class="file-user-id">
                                    <?= $displayUser ?>
                                </span>
                            </div>
                        </div>
                            <a href="<?= htmlspecialchars($image['image_url']) ?>" class="file-filename" download><?= basename($image['image_path']) ?></a>
                            <?php if (!empty($image['note'])): ?>
                                <div class="file-note">
                                    <?= htmlspecialchars($image['note']) ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</div>
