<?php
// Lägg till säkerhetsheaders
require_once __DIR__ . '/../../security.php';
setSecurityHeaders();
?>
<?php require_once __DIR__ . '/../admin_guard.php'; ?>
<!DOCTYPE html>
<html lang="sv">
<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width,initial-scale=1" />
    <title>Versionshistorik - ByggArkiv</title>
    <link rel="stylesheet" href="../common.css">
    <style>
        .page-title {
            text-align: left;
            color: #1a73e8;
            margin-bottom: 30px;
            font-size: 28px;
            font-weight: 600;
        }
        .history-container {
            background: white;
            border-radius: 12px;
            padding: 24px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }
        .history-item {
            border-bottom: 1px solid #e0e0e0;
            padding: 16px 0;
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
        }
        .history-item:last-child {
            border-bottom: none;
        }
        .commit-info {
            flex: 1;
        }
        .commit-hash {
            font-family: 'Courier New', monospace;
            background: #f8f9fa;
            padding: 4px 8px;
            border-radius: 4px;
            font-size: 12px;
            color: #1a73e8;
            font-weight: 600;
        }
        .commit-message {
            font-size: 14px;
            font-weight: normal;
            color: #333;
            margin: 8px 0 4px 0;
        }
        .commit-date {
            font-size: 14px;
            color: #666;
        }
        .commit-stats {
            text-align: right;
            min-width: 120px;
        }
        .commit-lines {
            font-size: 12px;
            color: #999;
        }
        .commit-files {
            font-size: 12px;
            color: #666;
            margin-top: 4px;
        }
        
        .commit-meta {
            font-size: 14px;
            color: #888;
            margin: 4px 0;
        }
        
        .commit-tag {
            color: #1a73e8;
            font-weight: 500;
            font-size: 14px;
        }
        
        .commit-branch {
            color: #34a853;
            font-weight: 500;
            font-size: 14px;
        }
        
        .commit-hash-text {
            color: #666;
            font-weight: 500;
            font-size: 14px;
        }
        
        .commit-date {
            font-size: 14px;
        }
        .no-history {
            text-align: center;
            color: #666;
            font-style: italic;
            padding: 40px;
        }
        .history-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            padding-bottom: 12px;
            border-bottom: 2px solid #e0e0e0;
        }
        .history-title {
            font-size: 20px;
            font-weight: 600;
            color: #333;
        }
        .history-count {
            font-size: 14px;
            color: #666;
            background: #f8f9fa;
            padding: 6px 12px;
            border-radius: 16px;
        }
        @media (max-width: 768px) {
            .history-item {
                flex-direction: column;
                gap: 12px;
            }
            .commit-stats {
                text-align: left;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <header class="header">
            <a href="../../index.html">
                <img src="../../data/logo.png" alt="ByggArkiv Snickare Stefan" class="logo">
            </a>
            <div class="back-link">
                <a href="../admin.php">← Tillbaka till admin</a>
            </div>
        </header>

        <h1 class="page-title">Versionshistorik</h1>

        <?php
        // Läs versionshistorik från JSON (genereras vid deploy)
        $historyJson = __DIR__ . '/../version_history.json';
        $history = [];

        if (file_exists($historyJson)) {
            $json = file_get_contents($historyJson);
            $data = json_decode($json, true);
            if (is_array($data)) { 
                $history = $data;

                // Sortera commits på datum, nyast först
                usort($history, function($a, $b) {
                    $ad = isset($a['date']) ? strtotime($a['date']) : 0;
                    $bd = isset($b['date']) ? strtotime($b['date']) : 0;
                    return $bd <=> $ad;
                });
            } else {
                // Debug: visa JSON-fel
                echo '<div class="history-container">';
                echo '<div class="no-history">JSON-fel: ' . json_last_error_msg() . '</div>';
                echo '</div>';
                exit;
            }
        }
        
        if (empty($history) || !is_array($history)) {
            echo '<div class="history-container">';
            echo '<div class="no-history">Ingen versionshistorik tillgänglig. Kör deploy-scriptet för att generera historik.</div>';
            echo '</div>';
        } else {
            echo '<div class="history-container">';
            
            foreach ($history as $commit) {
                echo '<div class="history-item">';
                echo '<div class="commit-info">';
                
                // Visa datum, tag/branch och commit hash på samma rad
                $tag = $commit['tag'] ?? '';
                $branch = $commit['branch'] ?? '';
                $date = $commit['date'] ?? 'Okänt datum';
                echo '<div class="commit-hash">';
                echo '<span class="commit-date">' . htmlspecialchars($date) . '</span>';
                if ($tag || $branch) {
                    echo ' <span class="commit-meta">';
                    if ($tag) {
                        echo '<span class="commit-tag">Tag: ' . htmlspecialchars($tag) . '</span>';
                    }
                    if ($tag && $branch) {
                        echo ' | ';
                    }
                    if ($branch) {
                        echo '<span class="commit-branch">Branch: ' . htmlspecialchars($branch) . '</span>';
                    }
                    echo '</span>';
                }
                echo ' <span class="commit-hash-text">' . htmlspecialchars($commit['hash'] ?? 'N/A') . '</span>';
                echo '</div>';
                
                $message = $commit['message'] ?? 'Ingen meddelande';
                // Konvertera newlines till <br> för att visa flerradiga meddelanden
                $message = nl2br(htmlspecialchars($message));
                echo '<div class="commit-message">' . $message . '</div>';
                
                
                // Visa om det finns ändrade filer
                if (isset($commit['files_changed']) && $commit['files_changed'] > 0) {
                    echo '<div class="commit-files">Ändrade filer: ' . $commit['files_changed'] . '</div>';
                }
                
                // Visa om det finns rader som lagts till/tagits bort
                if (isset($commit['lines_added']) || isset($commit['lines_deleted'])) {
                    $lines = [];
                    if (isset($commit['lines_added']) && $commit['lines_added'] > 0) {
                        $lines[] = 'Lagt till: ' . $commit['lines_added'] . ' rader';
                    }
                    if (isset($commit['lines_deleted']) && $commit['lines_deleted'] > 0) {
                        $lines[] = 'Tagit bort: ' . $commit['lines_deleted'] . ' rader';
                    }
                    if (!empty($lines)) {
                        echo '<div class="commit-lines">' . implode(' | ', $lines) . '</div>';
                    }
                }
                
                echo '</div>';
                echo '<div class="commit-stats">';
                echo '</div>';
                echo '</div>';
            }
            echo '</div>';
        }
        ?>

        <div style="text-align: center; margin-top: 20px;">
            <a href="../admin.php" class="admin-button" style="display: inline-block; text-decoration: none;">
                ← Tillbaka till admin
            </a>
        </div>
    </div>
</body>
</html>
