<?php
// Svara alltid JSON
header('Content-Type: application/json; charset=utf-8');

// Definiera UPLOAD_ROOT direkt här istället för att använda config.php
define('UPLOAD_ROOT', __DIR__ . '/../../uploads');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['ok' => false, 'error' => 'Method not allowed']);
    exit;
}

$filePath = $_POST['filePath'] ?? '';
if ($filePath === '') {
    http_response_code(400);
    echo json_encode(['ok' => false, 'error' => 'filePath saknas']);
    exit;
}

$uploadRoot = rtrim(UPLOAD_ROOT, '/\\');

// Säkerställ att vägen ligger under uploads
$realFile = realpath($filePath);
if ($realFile === false || !str_starts_with($realFile, realpath($uploadRoot))) {
    http_response_code(403);
    echo json_encode(['ok' => false, 'error' => 'Otillåten filväg']);
    exit;
}

// Härled .finfo-metadata om den finns
$metaPath = preg_replace('/\.[^.]+$/', '', $realFile) . '.finfo';

// Ta bort filer permanent
$ok = true;
$errors = [];

if (file_exists($realFile)) {
    if (!unlink($realFile)) {
        $ok = false;
        $errors[] = 'Kunde inte ta bort filen';
    }
} else {
    $errors[] = 'Filen finns inte';
}

if (file_exists($metaPath)) {
    if (!unlink($metaPath)) {
        // Metadata är valfri, så vi loggar inte fel om den inte kan tas bort
    }
}

if (!$ok) {
    http_response_code(500);
    echo json_encode(['ok' => false, 'error' => implode(', ', $errors)]);
    exit;
}

echo json_encode(['ok' => true, 'message' => 'Filer har tagits bort permanent.']);


