<?php
require_once __DIR__ . '/../../lib/data_functions.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: paketerade_projekt.php?error=method_not_allowed');
    exit;
}

$filename = $_POST['filename'] ?? '';

if (empty($filename)) {
    header('Location: paketerade_projekt.php?error=no_filename');
    exit;
}

// Validate filename to prevent directory traversal
if (strpos($filename, '..') !== false || strpos($filename, '/') !== false || strpos($filename, '\\') !== false) {
    header('Location: paketerade_projekt.php?error=invalid_filename');
    exit;
}

try {
    $downloadsDir = __DIR__ . '/../../downloads';
    $filePath = $downloadsDir . '/' . $filename;
    
    if (file_exists($filePath)) {
        if (unlink($filePath)) {
            header('Location: paketerade_projekt.php?success=deleted');
        } else {
            header('Location: paketerade_projekt.php?error=delete_failed');
        }
    } else {
        header('Location: paketerade_projekt.php?error=file_not_found');
    }
} catch (Exception $e) {
    header('Location: paketerade_projekt.php?error=exception');
}
?>
