<?php
require_once __DIR__ . '/../../lib/data_functions.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['ok' => false, 'error' => 'Method not allowed']);
    exit;
}

// Hämta parametrar
$imagePath = $_POST['imagePath'] ?? '';
$jsonPath = $_POST['jsonPath'] ?? '';
$newProjectId = $_POST['newProjectId'] ?? '';

if (empty($imagePath) || empty($jsonPath) || empty($newProjectId)) {
    echo json_encode(['ok' => false, 'error' => 'Alla parametrar krävs']);
    exit;
}

// Validera sökvägar
if (!file_exists($imagePath) || !file_exists($jsonPath)) {
    echo json_encode(['ok' => false, 'error' => 'En eller flera filer hittades inte']);
    exit;
}

// Hämta projektdata för att validera målprojektet (inklusive inaktiva projekt)
$projectsData = [];
$projectNames = [];
if (file_exists(__DIR__ . '/../data/projects.json')) {
    $projectsData = json_decode(file_get_contents(__DIR__ . '/../data/projects.json'), true) ?: [];
    foreach ($projectsData as $project) {
        $projectNames[$project['id']] = $project['name'];
    }
}

if (!isset($projectNames[$newProjectId])) {
    echo json_encode(['ok' => false, 'error' => 'Ogiltigt målprojekt']);
    exit;
}

// Hämta nuvarande projekt-ID från JSON-filen
$currentMetadata = json_decode(file_get_contents($jsonPath), true);
if (!$currentMetadata) {
    echo json_encode(['ok' => false, 'error' => 'Kunde inte läsa metadata']);
    exit;
}

$currentProjectId = $currentMetadata['project_id'] ?? '';
if ($currentProjectId === $newProjectId) {
    echo json_encode(['ok' => false, 'error' => 'Bilden är redan i det valda projektet']);
    exit;
}

// Skapa målprojektmapp om den inte finns
$uploadRoot = __DIR__ . '/../../' . rtrim(UPLOAD_ROOT, '/\\');
$targetProjectDir = $uploadRoot . '/' . $newProjectId;
if (!is_dir($targetProjectDir)) {
    if (!mkdir($targetProjectDir, 0755, true)) {
        echo json_encode(['ok' => false, 'error' => 'Kunde inte skapa målprojektmapp']);
        exit;
    }
}

// Hämta filnamn
$imageFilename = basename($imagePath);
$jsonFilename = basename($jsonPath);
// Thumb filnamn
$thumbPath = preg_replace('/\.(jpg|jpeg|png|webp|heic|heif)$/i', '', $imagePath) . '-thumb.jpg';
$thumbFilename = basename($thumbPath);

// Skapa nya sökvägar
$targetImagePath = $targetProjectDir . '/' . $imageFilename;
$targetJsonPath = $targetProjectDir . '/' . $jsonFilename;
$targetThumbPath = $targetProjectDir . '/' . $thumbFilename;

// Kontrollera om filen redan finns i målprojektet
if (file_exists($targetImagePath) || file_exists($targetJsonPath) || (file_exists($thumbPath) && file_exists($targetThumbPath))) {
    echo json_encode(['ok' => false, 'error' => 'En fil med samma namn finns redan i målprojektet']);
    exit;
}

try {
    // Flytta bildfilen
    if (!rename($imagePath, $targetImagePath)) {
        throw new Exception('Kunde inte flytta bildfilen');
    }
    
    // Flytta tumnagel om den finns
    if (file_exists($thumbPath)) {
        if (!rename($thumbPath, $targetThumbPath)) {
            // Om tumnagel inte kunde flyttas, flytta tillbaka bildfilen
            rename($targetImagePath, $imagePath);
            throw new Exception('Kunde inte flytta tumnagel');
        }
    }

    // Uppdatera metadata
    $currentMetadata['project_id'] = $newProjectId;
    $currentMetadata['project_name'] = $projectNames[$newProjectId];
    if (isset($currentMetadata['thumb_file'])) {
        // Lämna filnamnet oförändrat; endast mapp byts
    } else {
        // Om det finns en tumnagel på disk men metadata saknar fältet, fyll i det
        if (file_exists($targetThumbPath)) {
            $currentMetadata['thumb_file'] = $thumbFilename;
        }
    }
    
    // Skriv uppdaterad metadata
    if (file_put_contents($targetJsonPath, json_encode($currentMetadata, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE)) === false) {
        // Om JSON-skrivningen misslyckas, flytta tillbaka bildfilen
        rename($targetImagePath, $imagePath);
        throw new Exception('Kunde inte uppdatera metadata');
    }
    
    // Ta bort gamla JSON-filen
    unlink($jsonPath);
    
    echo json_encode([
        'ok' => true, 
        'message' => 'Bild flyttad till projekt: ' . $projectNames[$newProjectId],
        'newProjectId' => $newProjectId,
        'newProjectName' => $projectNames[$newProjectId]
    ]);
    
} catch (Exception $e) {
    echo json_encode(['ok' => false, 'error' => $e->getMessage()]);
}
?>
