<?php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../security.php';

setSecurityHeaders();
header('Content-Type: application/json; charset=utf-8');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['ok' => false, 'error' => 'Endast POST tillåten']);
    exit;
}

$filePath = sanitizeInput($_POST['filePath'] ?? '', 'file_path');
$originalProject = sanitizeInput($_POST['originalProject'] ?? '', 'project_id');

if ($filePath === '' || $originalProject === '') {
    http_response_code(400);
    echo json_encode(['ok' => false, 'error' => 'filePath och originalProject krävs']);
    exit;
}

// Kontrollera att filen finns i attic
$atticDir = __DIR__ . '/../../' . rtrim(UPLOAD_ROOT, '/\\') . DIRECTORY_SEPARATOR . 'attic';
$fullPath = $atticDir . DIRECTORY_SEPARATOR . basename($filePath);

if (!is_file($fullPath)) {
    http_response_code(404);
    echo json_encode(['ok' => false, 'error' => 'Filen hittades inte i attic']);
    exit;
}

// Kontrollera att målprojektet finns
$targetDir = __DIR__ . '/../../' . rtrim(UPLOAD_ROOT, '/\\') . DIRECTORY_SEPARATOR . basename($originalProject);
if (!is_dir($targetDir)) {
    http_response_code(404);
    echo json_encode(['ok' => false, 'error' => 'Målprojektet finns inte']);
    exit;
}

// Generera nytt säkert filnamn för målprojektet
$filename = basename($filePath);
$extension = pathinfo($filename, PATHINFO_EXTENSION);
$baseName = pathinfo($filename, PATHINFO_FILENAME);

$targetPath = $targetDir . DIRECTORY_SEPARATOR . $filename;
$counter = 1;
while (file_exists($targetPath)) {
    $targetPath = $targetDir . DIRECTORY_SEPARATOR . $baseName . '_' . $counter . '.' . $extension;
    $counter++;
}

// Flytta filen
if (!rename($fullPath, $targetPath)) {
    http_response_code(500);
    echo json_encode(['ok' => false, 'error' => 'Kunde inte flytta filen']);
    exit;
}

// Flytta metadata-fil om den finns
$metaPath = preg_replace('/\.[^.]+$/', '', $fullPath) . '.finfo';
$targetMetaPath = preg_replace('/\.[^.]+$/', '', $targetPath) . '.finfo';

if (is_file($metaPath)) {
    if (!rename($metaPath, $targetMetaPath)) {
        // Om metadata-flytten misslyckas, logga men fortsätt
        error_log("Kunde inte flytta metadata: $metaPath -> $targetMetaPath");
    }
}

echo json_encode(['ok' => true, 'message' => 'Filen återställdes framgångsrikt'], JSON_UNESCAPED_UNICODE);
