<?php
require_once __DIR__ . '/../admin_guard.php';
/**
 * Enkel dokumentuppladdning utan komplex validering (admin)
 */

// Svara alltid JSON
header('Content-Type: application/json; charset=utf-8');

// Suppressa warnings för ren JSON-output
error_reporting(E_ERROR);

// Kontrollera att det är en POST-förfrågan
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Endast POST tillåten']);
    exit;
}

// Validera input
$projectId = trim($_POST['project'] ?? '');
$note = trim($_POST['note'] ?? '');
// Hämta user_id från POST eller session (precis som upload.php gör)
$userId = $_POST['user_id'] ?? $_SESSION['user_id'] ?? '';

if (empty($projectId)) {
    echo json_encode(['success' => false, 'message' => 'Projekt måste väljas']);
    exit;
}

// Kontrollera att filer finns
if (!isset($_FILES['files']) || empty($_FILES['files']['name'][0])) {
    echo json_encode(['success' => false, 'message' => 'Inga filer valda']);
    exit;
}

$files = $_FILES['files'];
$uploadedCount = 0;
$errors = [];

// Skapa projektmapp om den inte finns (uploads ligger i projektroten)
$projectDir = __DIR__ . '/../../uploads/' . $projectId;
if (!is_dir($projectDir)) {
    mkdir($projectDir, 0755, true);
}

// Ladda upp varje fil
for ($i = 0; $i < count($files['name']); $i++) {
    if ($files['error'][$i] !== UPLOAD_ERR_OK) {
        $errors[] = "Fel vid uppladdning av {$files['name'][$i]}: Upload error {$files['error'][$i]}";
        continue;
    }

    $file = [
        'name' => $files['name'][$i],
        'type' => $files['type'][$i],
        'tmp_name' => $files['tmp_name'][$i],
        'error' => $files['error'][$i],
        'size' => $files['size'][$i]
    ];

    // Enkel validering
    if ($file['size'] > 25 * 1024 * 1024) {
        $errors[] = "Filen {$files['name'][$i]} är för stor (max 25 MB)";
        continue;
    }
    
    $extension = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
    if (!in_array($extension, ['pdf', 'txt', 'csv'])) {
        $errors[] = "Otillåten filtyp för {$files['name'][$i]}: $extension";
        continue;
    }

    // Generera enkelt filnamn
    $originalName = $file['name'];
    $timestamp = date('Ymd_His');
    $random = substr(md5(uniqid()), 0, 8);
    $secureFilename = $timestamp . '_' . $random . '.' . $extension;

    // Flytta fil till projektmapp
    $targetPath = $projectDir . '/' . $secureFilename;
    if (move_uploaded_file($file['tmp_name'], $targetPath)) {
        // Skapa metadata
        $metadata = [
            'project_id' => $projectId,
            'note' => $note,
            'user_id' => $userId,
            'original' => $originalName,
            'mime' => $file['type'],
            'bytes' => $file['size'],
            'stored_file' => $secureFilename,
            'stored_at' => date('c'),
            'file_type' => 'document'
        ];

        // Spara metadata (.finfo)
        $metadataFile = $projectDir . '/' . pathinfo($secureFilename, PATHINFO_FILENAME) . '.finfo';
        file_put_contents($metadataFile, json_encode($metadata, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));

        $uploadedCount++;
    } else {
        $errors[] = "Kunde inte flytta fil {$originalName}";
    }
}

// Returnera resultat
if ($uploadedCount > 0) {
    $message = "Laddade upp {$uploadedCount} dokument";
    if (!empty($errors)) {
        $message .= ". Varningar: " . implode('; ', $errors);
    }
    echo json_encode(['success' => true, 'message' => $message]);
} else {
    echo json_encode(['success' => false, 'message' => 'Inga filer kunde laddas upp. Fel: ' . implode('; ', $errors)]);
}
?>


