<?php
require_once __DIR__ . '/../../config.php';

// Svara alltid JSON
header('Content-Type: application/json; charset=utf-8');

// Sökväg till projects.json
$projectsFile = __DIR__ . '/../../data/projects.json';

// Funktion för att läsa projekt från JSON-fil
function readProjects($filePath) {
  if (!file_exists($filePath)) {
    return [];
  }
  $content = file_get_contents($filePath);
  if ($content === false) {
    return [];
  }
  $projects = json_decode($content, true);
  return is_array($projects) ? $projects : [];
}

try {
  $projects = readProjects($projectsFile);

  // Filtrera bara aktiva projekt (denna endpoint används av admin-sida men visar aktiva för listning)
  $activeProjects = array_filter($projects, function($project) {
    return ($project['status'] ?? 'active') === 'active';
  });

  echo json_encode([
    'success' => true,
    'projects' => array_values($activeProjects)
  ]);

} catch (Exception $e) {
  http_response_code(500);
  echo json_encode([
    'success' => false,
    'message' => $e->getMessage()
  ]);
}
?>


