<?php
require_once __DIR__ . '/../../lib/data_functions.php';
?>
<link rel="stylesheet" href="../common.css">
<style>
/* Lightbox Modal Styles for project_view.php */
.lightbox {
    display: none;
    position: fixed;
    z-index: 1000;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, 0.9);
    backdrop-filter: blur(5px);
}

.lightbox-content {
    position: relative;
    margin: auto;
    padding: 20px;
    width: 90%;
    height: 90%;
    display: flex;
    align-items: center;
    justify-content: center;
}

.lightbox-image {
    max-width: 100%;
    max-height: 100%;
    object-fit: contain;
    border-radius: 8px;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.5);
}

.lightbox-close {
    position: absolute;
    top: 20px;
    right: 35px;
    color: #f1f1f1;
    font-size: 40px;
    font-weight: bold;
    cursor: pointer;
    z-index: 1001;
    background: rgba(0, 0, 0, 0.5);
    border-radius: 50%;
    width: 50px;
    height: 50px;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: background-color 0.2s;
}

.lightbox-close:hover {
    background: rgba(0, 0, 0, 0.8);
}

.lightbox-info {
    position: absolute;
    bottom: 20px;
    left: 20px;
    right: 20px;
    background: rgba(0, 0, 0, 0.8);
    color: white;
    padding: 15px;
    border-radius: 8px;
    font-size: 14px;
}

.lightbox-filename {
    font-weight: bold;
    margin-bottom: 5px;
}

.lightbox-meta {
    display: flex;
    justify-content: space-between;
    flex-wrap: wrap;
    gap: 10px;
}

.file-image {
    cursor: default;
    transition: opacity 0.2s;
}

.file-image:hover {
    opacity: 0.9;
}

.file-note {
    margin-top: 6px;
    padding: 6px 8px 2px 8px;
    background: #e3f2fd;
    border-radius: 4px;
    font-style: normal;
    font-weight: normal;
    color: #1976d2;
    margin-bottom: 2px;
    word-wrap: break-word;
}

.edit-btn {
    position: absolute;
    top: 8px;
    right: 119px;
    background: white;
    color: #ff9800;
    border: 2px solid #ff9800;
    border-radius: 50%;
    width: 30px;
    height: 30px;
    font-size: 16px;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    opacity: 0.9;
    transition: opacity 0.2s;
    z-index: 10;
    pointer-events: auto;
}
.edit-btn:hover {
    opacity: 1;
    background: #ff9800;
    color: white;
}

@media (max-width: 768px) {
    .lightbox-content {
        width: 95%;
        height: 95%;
        padding: 10px;
    }
    .lightbox-close {
        top: 10px;
        right: 20px;
        font-size: 30px;
        width: 40px;
        height: 40px;
    }
    .lightbox-info {
        bottom: 10px;
        left: 10px;
        right: 10px;
        padding: 10px;
        font-size: 12px;
    }
    .lightbox-meta {
        flex-direction: column;
        gap: 5px;
    }
}

/* Button styles for project_view.php */
.view-btn {
    position: absolute;
    top: 8px;
    right: 82px;
    background: white;
    color: #1a73e8;
    border: 2px solid #1a73e8;
    border-radius: 50%;
    width: 30px;
    height: 30px;
    font-size: 16px;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    opacity: 0.9;
    transition: opacity 0.2s;
    z-index: 10;
    pointer-events: auto;
}
.view-btn:hover {
    opacity: 1;
    background: #1a73e8;
    color: white;
}

.move-btn {
    position: absolute;
    top: 8px;
    right: 45px;
    background: white;
    color: #28a745;
    border: 2px solid #28a745;
    border-radius: 50%;
    width: 30px;
    height: 30px;
    font-size: 16px;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    opacity: 0.9;
    transition: opacity 0.2s;
    z-index: 10;
    pointer-events: auto;
}
.move-btn:hover {
    opacity: 1;
    background: #28a745;
    color: white;
}

.delete-btn {
    position: absolute;
    top: 8px;
    right: 8px;
    background: white;
    color: #dc3545;
    border: 2px solid #dc3545;
    border-radius: 50%;
    width: 30px;
    height: 30px;
    font-size: 16px;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    opacity: 0.9;
    transition: opacity 0.2s;
    z-index: 10;
    pointer-events: auto;
}
.delete-btn:hover {
    opacity: 1;
    background: #dc3545;
    color: white;
}

.edit-btn {
    position: absolute;
    top: 8px;
    right: 119px;
    background: white;
    color: #ff9800;
    border: 2px solid #ff9800;
    border-radius: 50%;
    width: 30px;
    height: 30px;
    font-size: 16px;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    opacity: 0.9;
    transition: opacity 0.2s;
    z-index: 10;
    pointer-events: auto;
}
.edit-btn:hover {
    opacity: 1;
    background: #ff9800;
    color: white;
}
</style>
<?php

$data = getAllUploadData();
$projectsData = $data['projectsData'];
$allUploads = $data['allUploads'];
$projectNames = $data['projectNames'];

// Hämta valt projekt från URL-parameter
$selectedProject = $_GET['project_id'] ?? '';

// Kontrollera om projektet är arkiverat
$selectedProjectIsArchived = false;
if ($selectedProject) {
    foreach ($projectsData as $proj) {
        if ($proj['id'] == $selectedProject) {
            $status = $proj['status'] ?? 'active';
            if ($status === 'archived') {
                $selectedProjectIsArchived = true;
            }
            break;
        }
    }
}

// Kontrollera om arkiverade projekt ska visas (från kryssruta eller om projektet är aktivt)
$showArchived = isset($showArchived) ? $showArchived : false;

// Om projektet är arkiverat och kryssrutan inte är ikryssad, visa inget
if ($selectedProjectIsArchived && !$showArchived) {
    $filteredUploads = [];
} else {
    // Filtrera uppladdningar baserat på valt projekt
    $filteredUploads = [];
    if ($selectedProject) {
        $filteredUploads = array_filter($allUploads, function($upload) use ($selectedProject) {
            return $upload['project_id'] === $selectedProject;
        });
        
        // Sortera efter datum (nyaste först)
        usort($filteredUploads, function($a, $b) {
            return strtotime($b['stored_at']) - strtotime($a['stored_at']);
        });
    }
}

// Hitta projektnamn för valt projekt
$selectedProjectName = '';
if ($selectedProject && isset($projectNames[$selectedProject])) {
    $selectedProjectName = $projectNames[$selectedProject];
    // Ta bort projekt-ID från början om det finns
    if (str_starts_with($selectedProjectName, $selectedProject . ' – ')) {
        $selectedProjectName = substr($selectedProjectName, strlen($selectedProject . ' – '));
    }
}
?>

<div class="results-section">
    <div class="results-header">
        <?php if ($selectedProject): ?>
            <div style="font-size: 18px; font-weight: 600; margin-bottom: 4px;">
                <?= htmlspecialchars($selectedProjectName) ?>
            </div>
            <div style="font-size: 14px; opacity: 0.8;">
                Projekt: <?= htmlspecialchars($selectedProject) ?>
                <span style="margin-left: 8px;">(<?= count($filteredUploads) ?> filer)</span>
            </div>
        <?php else: ?>
            <span id="resultsTitle">Välj ett projekt för att visa bilder</span>
        <?php endif; ?>
    </div>
    <div class="results-content">
        <?php if (empty($filteredUploads)): ?>
            <div class="no-results" >
                <?php if ($selectedProject): ?>
                    Inga filer uppladdade än
                <?php else: ?>
                    Välj ett projekt för att visa bilder.
                <?php endif; ?>
            </div>
        <?php else: ?>
            <div class="file-grid">
                <?php foreach ($filteredUploads as $upload): ?>
                    <div class="file-item" 
                         data-project="<?= htmlspecialchars($upload['project_id']) ?>"
                         data-project-id="<?= htmlspecialchars($upload['project_id']) ?>"
                         data-upload-id="<?= htmlspecialchars($upload['upload_id'] ?? '') ?>"
                         data-user-id="<?= htmlspecialchars($upload['user_id'] ?? '') ?>"
                         data-image-path="<?= htmlspecialchars($upload['image_path']) ?>"
                         data-json-path="<?= htmlspecialchars(str_replace(['.jpg', '.png', '.heic', '.heif', '.mp4', '.webm', '.mov', '.avi'], '.json', $upload['image_path'])) ?>"
                         <?php 
                        $uid = $upload['user_id'] ?? '';
                        $uname = getUserFullName($uid);
                        $displayUser = $uname !== '' ? $uname : 'Ingen användare';
                        $displayDate = date('Y-m-d H:i', strtotime($upload['stored_at']));
                        $filename = basename($upload['image_path']);
                        $note = $upload['note'] ?? '';
                        $isVideo = ($upload['file_type'] ?? 'image') === 'video';
                        $imageNumber = isset($upload['image_number']) && is_numeric($upload['image_number']) ? (int)$upload['image_number'] : null;
                        $imageNumberText = $imageNumber !== null ? ($isVideo ? 'Video #' . $imageNumber : 'Bild #' . $imageNumber) : '';
                        
                        // Generate image_url - anpassa sökväg baserat på var filen inkluderas från
                        $imageUrl = '../../view_file.php?project_id=' . urlencode($upload['project_id']) . '&file=' . urlencode(basename($upload['image_path']));
                        ?>
                         data-image-url="<?= htmlspecialchars($imageUrl) ?>"
                         data-full-image-url="<?= htmlspecialchars($imageUrl) ?>"
                         data-filename="<?= htmlspecialchars($filename) ?>"
                         data-date="<?= htmlspecialchars($displayDate) ?>"
                         data-user="<?= htmlspecialchars($displayUser) ?>"
                         data-note="<?= htmlspecialchars($note) ?>"
                         data-image-number="<?= htmlspecialchars($imageNumberText) ?>"
                         >
                        <?php 
                        if ($isVideo): ?>
                            <video class="file-image" 
                                   controls 
                                   preload="metadata">
                                <source src="<?= htmlspecialchars($imageUrl) ?>" type="<?= htmlspecialchars($upload['mime'] ?? 'video/mp4') ?>">
                                Din webbläsare stöder inte videouppspelning.
                            </video>
                        <?php else: 
                            // Generera thumbnail-sökväg för bilder
                            $baseNoExt = preg_replace('/\.(jpg|jpeg|png|webp|heic|heif)$/i', '', basename($upload['image_path']));
                            $thumbUrl = '../../view_file.php?project_id=' . urlencode($upload['project_id']) . '&file=' . urlencode($baseNoExt . '-thumb.jpg');
                        ?>
                            <img src="<?= htmlspecialchars($thumbUrl) ?>" 
                                 alt="Bild" 
                                 class="file-image"
                                 loading="lazy"
                                 onerror="this.src='<?= htmlspecialchars($imageUrl) ?>'; this.onerror=null;">
                        <?php endif; ?>
                        
                        <div class="file-overlay">
                            <button class="view-btn" title="Visa fil i full storlek"><img src="../icons/view.svg" width="16" height="16" alt="Visa"></button>
                            <button class="move-btn" onclick="moveFile(this)" title="Flytta till annat projekt"><img src="../icons/move.svg" width="16" height="16" alt="Flytta"></button>
                            <button class="delete-btn" onclick="deleteFile(this)" title="Ta bort fil"><img src="../icons/delete.svg" width="16" height="16" alt="Ta bort"></button>
                            <button class="edit-btn" onclick="addDescription(this)" title="<?= empty($upload['note']) ? 'Ändra beskrivning' : 'Redigera beskrivning' ?>"><img src="../icons/edit.svg" width="16" height="16" alt="Redigera"></button>
                        </div>
                        <div class="file-info">
                            <?php if ($imageNumberText): ?>
                                <div class="file-image-number" style="color: #000; margin-bottom: 4px;">
                                    <?= htmlspecialchars($imageNumberText) ?>
                                </div>
                            <?php endif; ?>
                            <?php 
                            $uid = $upload['user_id'] ?? '';
                            $uname = getUserFullName($uid);
                            $displayUser = $uname !== '' ? htmlspecialchars($uname) : 'Ingen användare';
                            $displayDate = date('Y-m-d H:i', strtotime($upload['stored_at']));
                            $origSizeText = number_format(($upload['bytes'] ?? 0) / 1024 / 1024, 1) . 'M';
                            $thumbSizeText = '';
                            if (!empty($upload['thumb_path']) && file_exists($upload['thumb_path'])) {
                                $thumbBytes = @filesize($upload['thumb_path']);
                                if ($thumbBytes !== false) {
                                    $thumbSizeText = ' (' . number_format($thumbBytes / 1024, 1) . 'k)';
                                }
                            }
                            ?>
                            <div class="file-meta">
                                <div class="file-meta-row">
                                    <span class="file-date"><?= $displayDate ?>    <?= $origSizeText ?><?= $thumbSizeText ?></span>
                                    <span class="file-user-id">
                                        <?= $displayUser ?>
                                    </span>
                                </div>

                            </div>
                            <a href="<?= htmlspecialchars($upload["image_url"]) ?>" class="file-filename" download><?= basename($upload["image_path"]) ?></a>
                            <?php if (!empty($upload['note'])): ?>
                                <div class="file-note">
                                    <?= htmlspecialchars($upload['note']) ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</div>

<script>
function addDescription(button) {
    const fileItem = button.closest('.file-item');
    if (!fileItem) {
        console.error('File item not found');
        return;
    }
    
    const imagePath = fileItem.dataset.imagePath;
    const jsonPath = fileItem.dataset.jsonPath;
    
    if (!imagePath || !jsonPath) {
        console.error('Missing file paths:', { imagePath, jsonPath });
        alert('Fel: Saknade filvägar');
        return;
    }
    
    const currentDescription = prompt('Ändra beskrivning för denna bild:');
    if (currentDescription === null) {
        return; // User cancelled
    }
    
    const formData = new FormData();
    formData.append('imagePath', imagePath);
    formData.append('jsonPath', jsonPath);
    formData.append('description', currentDescription);
    
    // Hämta user_id från URL eller cookie
    const urlParams = new URLSearchParams(window.location.search);
    const userId = urlParams.get('user_id') || (function() {
        const cookies = document.cookie.split(';');
        for (let cookie of cookies) {
            const [name, value] = cookie.trim().split('=');
            if (name === 'user_id') {
                return decodeURIComponent(value);
            }
        }
        return '';
    })();
    if (userId) {
        formData.append('user_id', userId);
    }
    
    fetch('../../api/files/add_description.php', {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(result => {
        if (result.ok) {
            // Hide the edit button and add the description
            button.style.display = 'none';
            const noteDiv = document.createElement('div');
            noteDiv.className = 'file-note';
            noteDiv.style.cssText = 'margin-top: 6px; padding: 6px 8px 2px 8px; background: #e3f2fd; border-radius: 4px; font-style: normal; font-weight: normal; color: #1976d2; margin-bottom: 2px; word-wrap: break-word;';
            noteDiv.textContent = currentDescription;
            const fileInfo = button.closest('.file-item')?.querySelector('.file-info');
            if (fileInfo) {
                const filenameLink = fileInfo.querySelector('.file-filename');
                if (filenameLink && filenameLink.parentNode === fileInfo) {
                    fileInfo.insertBefore(noteDiv, filenameLink.nextSibling);
                } else {
                    fileInfo.appendChild(noteDiv);
                }
            } else {
                button.parentNode.appendChild(noteDiv);
            }
        } else {
            alert('Fel: ' + result.error);
        }
    })
    .catch(error => {
        console.error('Add description error:', error);
        alert('Ett fel uppstod: ' + error.message);
    });
}

// Modal styles for description popup
const modalStyles = `
<style>
.modal {
    position: fixed;
    z-index: 1000;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, 0.5);
    display: flex;
    align-items: center;
    justify-content: center;
}

.modal-content {
    background-color: white;
    border-radius: 12px;
    width: 90%;
    max-width: 500px;
    max-height: 90vh;
    overflow-y: auto;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.3);
}

.modal-header {
    padding: 20px 20px 0 20px;
    display: flex;
    justify-content: space-between;
    align-items: center;
    border-bottom: 1px solid #eee;
    padding-bottom: 15px;
}

.modal-header h3 {
    margin: 0;
    color: #1a73e8;
}

.close {
    color: #aaa;
    font-size: 28px;
    font-weight: bold;
    cursor: pointer;
    line-height: 1;
}

.close:hover {
    color: #000;
}

.modal-body {
    padding: 20px;
}

.modal-footer {
    padding: 0 20px 20px 20px;
    display: flex;
    gap: 12px;
    justify-content: flex-end;
}

.form-group {
    margin-bottom: 20px;
}

.form-group label {
    display: block;
    font-weight: 600;
    margin-bottom: 8px;
    color: #333;
}

.form-group textarea {
    width: 100%;
    padding: 10px;
    border: 1px solid #ccc;
    border-radius: 8px;
    font-size: 16px;
    box-sizing: border-box;
    resize: vertical;
    min-height: 80px;
}

.btn-primary {
    background: #1a73e8;
    color: white;
    border: none;
    padding: 12px 20px;
    border-radius: 8px;
    font-size: 16px;
    cursor: pointer;
    font-weight: 500;
}

.btn-primary:hover {
    background: #1557b0;
}

.btn-secondary {
    background: #6c757d;
    color: white;
    border: none;
    padding: 12px 20px;
    border-radius: 8px;
    font-size: 16px;
    cursor: pointer;
    font-weight: 500;
}

.btn-secondary:hover {
    background: #5a6268;
}
</style>
`;

// Add modal styles to head
if (!document.querySelector('#description-modal-styles')) {
    const styleElement = document.createElement('div');
    styleElement.id = 'description-modal-styles';
    styleElement.innerHTML = modalStyles;
    document.head.appendChild(styleElement);
}

// Create modal HTML
const modalHTML = `
<div id="descriptionModal" class="modal" style="display: none;">
    <div class="modal-content">
        <div class="modal-header">
            <h3>Ändra beskrivning</h3>
            <span class="close" onclick="closeDescriptionModal()">&times;</span>
        </div>
        <div class="modal-body">
            <div class="form-group">
                <label for="descriptionText">Beskrivning för bilden:</label>
                <textarea id="descriptionText" rows="4" placeholder="Skriv en beskrivning för denna bild..."></textarea>
            </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn-secondary" onclick="closeDescriptionModal()">Avbryt</button>
            <button type="button" class="btn-primary" onclick="saveDescription()">Spara</button>
        </div>
    </div>
</div>
`;

// Modal functionality handled by parent file
</script>

