<?php 
require_once __DIR__ . '/admin_guard.php';
$script = $_SERVER['SCRIPT_NAME'] ?? '';
$admPos = strpos($script, '/adm/');
$adminUrl = ($admPos !== false ? substr($script, 0, $admPos + 4) : '/adm') . '/admin.php';
?>
<!DOCTYPE html>
<html lang="sv">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title>Systemmeddelanden - ByggArkiv Admin</title>
  <link rel="stylesheet" href="common.css">
  <style>
    .container { max-width: 900px; }
    .message-item {
      display: flex;
      justify-content: space-between;
      align-items: flex-start;
      padding: 16px;
      background: #f8f9fa;
      border: 1px solid #e9ecef;
      border-radius: 8px;
      margin-bottom: 12px;
      transition: all 0.2s;
    }
    .message-item:hover {
      background: #e9ecef;
      border-color: #1a73e8;
    }
    .message-info {
      flex: 1;
    }
    .message-content {
      font-size: 16px;
      color: #333;
      line-height: 1.6;
      white-space: pre-wrap;
      word-wrap: break-word;
      margin-bottom: 8px;
    }
    .message-meta {
      font-size: 12px;
      color: #666;
      margin-bottom: 4px;
    }
    .message-stats {
      font-size: 12px;
      color: #666;
    }
        .message-actions {
            display: flex;
            gap: 8px;
            align-items: flex-start;
        }
        .delete-btn {
            background: #dc3545;
            color: white;
            border: none;
            border-radius: 6px;
            padding: 6px;
            cursor: pointer;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            transition: background 0.2s;
            min-width: 36px;
            height: 36px;
            box-sizing: border-box;
        }
        .delete-btn:hover {
            background: #c82333;
        }
        .delete-btn svg {
            width: 20px;
            height: 20px;
        }
  </style>
</head>
<body>
  <div class="container">
    <header class="header">
      <a href="../../index.html">
        <img src="../data/logo.png" alt="ByggArkiv Snickare Stefan" class="logo">
      </a>
      <div class="back-link">
        <a href="<?= htmlspecialchars($adminUrl) ?>">← Tillbaka till admin</a>
      </div>
    </header>
    
    <div class="card">
      <h1>Systemmeddelanden</h1>
      <p class="subtitle">Författa och hantera systemmeddelanden som visas för alla användare</p>
      
      <div style="margin: 20px 0;">
        <button id="addMessageBtn" onclick="showAddMessagePopup()" class="admin-button">Skapa nytt meddelande</button>
      </div>
      
      <div class="project-list" id="messagesList">
        <div class="empty-state">Laddar...</div>
      </div>
      
      <div id="status" class="status" style="display: none;"></div>
    </div>
  </div>
  
  <!-- Popup för att skapa nytt meddelande -->
  <div id="addMessagePopup" class="confirm-overlay" style="display: none;">
    <div class="confirm-box" style="max-width: 600px;">
      <h3 class="confirm-title">Skapa nytt systemmeddelande</h3>
      <form id="messageForm">
        <div class="form-group">
          <label for="messageText">Meddelandetext</label>
          <textarea id="messageText" placeholder="Skriv systemmeddelandet här..." rows="8" style="width: 100%; padding: 12px; border: 1px solid #ccc; border-radius: 8px; font-size: 16px; box-sizing: border-box; font-family: inherit; resize: vertical;"></textarea>
        </div>
        <div class="form-group">
          <div style="display: flex; align-items: center; gap: 8px;">
            <input type="checkbox" id="includeExternal" name="include_external" value="1">
            <label for="includeExternal" style="margin: 0; font-weight: normal; cursor: pointer;">Inkludera externa användare</label>
          </div>
        </div>
        <div class="form-group">
          <label for="expiresAt">Sista visningsdag (valfritt)</label>
          <input type="date" id="expiresAt" name="expires_at" style="width: 100%; padding: 12px; border: 1px solid #ccc; border-radius: 8px; font-size: 16px; box-sizing: border-box;">
          <small style="color: #666; font-size: 12px; display: block; margin-top: 4px;">Efter detta datum visas meddelandet inte längre för besökare</small>
        </div>
        <div class="confirm-actions">
          <button type="submit" class="confirm-btn confirm-btn-primary">Skapa meddelande</button>
          <button type="button" onclick="hideAddMessagePopup()" class="confirm-btn confirm-btn-cancel">Avbryt</button>
        </div>
      </form>
    </div>
  </div>
  
  <!-- Bekräftelsedialog för borttagning -->
  <div class="confirm-overlay" id="confirmOverlay" style="display: none;">
    <div class="confirm-box">
      <h3 class="confirm-title" id="confirmTitle">Bekräfta</h3>
      <p id="confirmMessage"></p>
      <div class="confirm-actions">
        <button class="confirm-btn confirm-btn-cancel" onclick="closeConfirm()">Avbryt</button>
        <button class="confirm-btn confirm-btn-danger" id="confirmActionBtn">Bekräfta</button>
      </div>
    </div>
  </div>
  
  <script>
    // Hämta user_id från URL, cookie eller session (som admin_guard.php gör)
    function getUserId() {
      // Försök hämta från URL först
      const urlParams = new URLSearchParams(window.location.search);
      const urlUserId = urlParams.get('user_id');
      if (urlUserId) {
        return urlUserId;
      }
      
      // Försök hämta från cookie
      const cookies = document.cookie.split(';');
      for (let cookie of cookies) {
        const [name, value] = cookie.trim().split('=');
        if (name === 'user_id' && value) {
          return decodeURIComponent(value);
        }
      }
      
      return '';
    }
    
    const userId = getUserId();
    
    // Visa popup för att skapa nytt meddelande
    function showAddMessagePopup() {
      document.getElementById('addMessagePopup').style.display = 'flex';
      document.getElementById('messageText').value = '';
      document.getElementById('messageText').focus();
    }
    
    // Dölj popup för att skapa nytt meddelande
    function hideAddMessagePopup() {
      document.getElementById('addMessagePopup').style.display = 'none';
      document.getElementById('expiresAt').value = '';
    }
    
    // Funktion för att hämta användarnamn från user_id
    async function getUserName(userId) {
      if (!userId) return 'Okänd';
      
      try {
        const response = await fetch(`../api/user_info.php?user_id=${encodeURIComponent(userId)}`);
        if (!response.ok) {
          return userId; // Fallback till user_id om API-anropet misslyckas
        }
        
        const data = await response.json();
        if (data.success && data.user && data.user.full_name) {
          return data.user.full_name;
        }
        return userId; // Fallback till user_id om namn saknas
      } catch (error) {
        console.error('Fel vid hämtning av användarnamn:', error);
        return userId; // Fallback till user_id vid fel
      }
    }
    
    // Ladda alla meddelanden
    async function loadMessages() {
      try {
        const response = await fetch(`../api/system_message.php?action=list&user_id=${encodeURIComponent(userId)}`);
        const data = await response.json();
        
        const messagesList = document.getElementById('messagesList');
        
        if (data.success && data.messages && data.messages.length > 0) {
          messagesList.innerHTML = '';
          
          // Ladda statistik
          const statsResponse = await fetch(`../api/system_message.php?action=stats&user_id=${encodeURIComponent(userId)}`);
          const statsData = await statsResponse.json();
          
          const statsMap = {};
          if (statsData.success && statsData.message_stats) {
            statsData.message_stats.forEach(stat => {
              statsMap[stat.id] = stat;
            });
          }
          
          // Hämta användarnamn för alla skapare
          const creatorNames = {};
          for (const message of data.messages) {
            if (message.created_by && !creatorNames[message.created_by]) {
              creatorNames[message.created_by] = await getUserName(message.created_by);
            }
          }
          
          data.messages.forEach(message => {
            const messageDiv = document.createElement('div');
            messageDiv.className = 'message-item';
            
            const created = new Date(message.created_at).toLocaleString('sv-SE');
            const stats = statsMap[message.id] || { read_count: 0, total_users: 0 };
            const creatorName = creatorNames[message.created_by] || message.created_by || 'Okänd';
            const includeExternal = message.include_external ? ' (inkluderar externa användare)' : '';
            const expiresAt = message.expires_at ? new Date(message.expires_at).toLocaleDateString('sv-SE') : null;
            const isExpired = expiresAt && new Date(message.expires_at) < new Date();
            const expiresText = expiresAt 
              ? ` • Sista visningsdag: ${expiresAt}${isExpired ? ' <span style="color: #dc3545; font-weight: 600;">(UTGÅNGET)</span>' : ''}`
              : '';
            
            messageDiv.innerHTML = `
              <div class="message-info">
                <div class="message-content">${escapeHtml(message.message)}</div>
                <div class="message-meta">Skapat: ${created} av ${escapeHtml(creatorName)}${includeExternal}${expiresText}</div>
                <div class="message-stats">Läst av ${stats.read_count} av ${stats.total_users} användare</div>
              </div>
              <div class="message-actions">
                <button class="delete-btn" onclick="deleteMessage('${message.id}')" title="Ta bort meddelande">
                  <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M6 19c0 1.1.9 2 2 2h8c1.1 0 2-.9 2-2V7H6v12zM19 4h-3.5l-1-1h-5l-1 1H5v2h14V4z"/>
                  </svg>
                </button>
              </div>
            `;
            
            messagesList.appendChild(messageDiv);
          });
        } else {
          messagesList.innerHTML = '<div class="empty-state">Inga systemmeddelanden ännu</div>';
        }
      } catch (error) {
        console.error('Fel vid laddning av meddelanden:', error);
        document.getElementById('messagesList').innerHTML = '<div class="empty-state">Fel vid laddning av meddelanden</div>';
      }
    }
    
    function escapeHtml(text) {
      const div = document.createElement('div');
      div.textContent = text;
      return div.innerHTML;
    }
    
    // Skapa nytt meddelande
    document.getElementById('messageForm').addEventListener('submit', async (e) => {
      e.preventDefault();
      
      const messageText = document.getElementById('messageText').value.trim();
      const includeExternal = document.getElementById('includeExternal').checked;
      const expiresAt = document.getElementById('expiresAt').value;
      
      if (!messageText) {
        showStatus('Meddelandetext krävs', 'error');
        return;
      }
      
      try {
        const formData = new FormData();
        formData.append('action', 'save');
        formData.append('message', messageText);
        formData.append('include_external', includeExternal ? '1' : '0');
        if (expiresAt) {
          formData.append('expires_at', expiresAt);
        }
        formData.append('user_id', userId);
        
        const response = await fetch('../api/system_message.php', {
          method: 'POST',
          body: formData
        });
        
        const data = await response.json();
        
        if (data.success) {
          showStatus('Systemmeddelande skapat', 'success');
          hideAddMessagePopup();
          await loadMessages();
        } else {
          showStatus('Fel: ' + data.message, 'error');
        }
      } catch (error) {
        console.error('Fel vid sparande:', error);
        showStatus('Ett fel uppstod', 'error');
      }
    });
    
    // Ta bort meddelande
    function deleteMessage(messageId) {
      showConfirm(
        'Ta bort systemmeddelande',
        'Är du säker på att du vill ta bort detta systemmeddelande? Alla användare kommer att behöva läsa det igen om du skapar ett nytt.',
        async () => {
          try {
            const formData = new FormData();
            formData.append('action', 'delete');
            formData.append('message_id', messageId);
            formData.append('user_id', userId);
            
            const response = await fetch('../api/system_message.php', {
              method: 'POST',
              body: formData
            });
            
            const data = await response.json();
            
            if (data.success) {
              showStatus('Systemmeddelande borttaget', 'success');
              await loadMessages();
            } else {
              showStatus('Fel: ' + data.message, 'error');
            }
          } catch (error) {
            console.error('Fel vid borttagning:', error);
            showStatus('Ett fel uppstod', 'error');
          }
          closeConfirm();
        }
      );
    }
    
    function showStatus(message, type) {
      const statusEl = document.getElementById('status');
      statusEl.textContent = message;
      statusEl.className = 'status ' + type;
      statusEl.style.display = 'block';
      
      setTimeout(() => {
        statusEl.style.display = 'none';
      }, 5000);
    }
    
    function showConfirm(title, message, onConfirm) {
      document.getElementById('confirmTitle').textContent = title;
      document.getElementById('confirmMessage').textContent = message;
      document.getElementById('confirmOverlay').style.display = 'flex';
      
      const btn = document.getElementById('confirmActionBtn');
      btn.onclick = () => {
        onConfirm();
      };
    }
    
    function closeConfirm() {
      document.getElementById('confirmOverlay').style.display = 'none';
    }
    
    // Ladda meddelanden när sidan laddas
    loadMessages();
  </script>
</body>
</html>
