<?php
require_once __DIR__ . '/../lib/data_functions.php';
?>
<link rel="stylesheet" href="../common.css">
<?php
$data = getAllUploadData();
$allUploads = $data['allUploads'];
$projectNames = $data['projectNames'];

// Hämta valt user_id från URL-parameter
$selectedUserId = $_GET['filter_user_id'] ?? '';

// Filtrera uppladdningar baserat på valt user_id
$filteredUploads = [];
if ($selectedUserId === '') {
    // Placeholder vald: visa tom lista
    $filteredUploads = [];
} elseif ($selectedUserId === '__EMPTY__') {
    // Visa alla uppladdningar utan user_id
    $filteredUploads = array_filter($allUploads, function($upload) {
        return !isset($upload['user_id']) || $upload['user_id'] === '' || $upload['user_id'] === null;
    });
} else {
    // Specifikt user_id valt
    $filteredUploads = array_filter($allUploads, function($upload) use ($selectedUserId) {
        return isset($upload['user_id']) && $upload['user_id'] === $selectedUserId;
    });
}

// Sortera efter datum (nyaste först) om det finns bilder
if (!empty($filteredUploads)) {
    usort($filteredUploads, function($a, $b) {
        return strtotime($b['stored_at']) - strtotime($a['stored_at']);
    });
}
?>

<div class="results-section">
    <div class="results-header">
        <?php if ($selectedUserId === ''): ?>
            <span id="resultsTitle">Välj en användare för att visa bilder</span>
        <?php elseif ($selectedUserId === '__EMPTY__'): ?>
            <div style="font-size: 18px; font-weight: 600; margin-bottom: 4px;">
                Uppladdningar utan användare
            </div>
            <div style="font-size: 14px; opacity: 0.8;">
                <span>(<?= count($filteredUploads) ?> bilder)</span>
            </div>
        <?php else: ?>
            <?php 
            $userName = getUserFullName($selectedUserId);
            $displayText = $userName !== '' ? $userName : 'Användare ' . htmlspecialchars($selectedUserId);
            ?>
            <div style="font-size: 18px; font-weight: 600; margin-bottom: 4px;">
                <?= htmlspecialchars($displayText) ?>
            </div>
            <div style="font-size: 14px; opacity: 0.8;">
                <?php 
                $userName = getUserFullName($selectedUserId);
                $displayUserId = $userName !== '' ? $userName : $selectedUserId;
                ?>
                Användare: <?= htmlspecialchars($displayUserId) ?>
                <span style="margin-left: 8px;">(<?= count($filteredUploads) ?> bilder)</span>
            </div>
        <?php endif; ?>
    </div>
    <div class="results-content">
        <?php if (empty($filteredUploads)): ?>
            <div class="no-results">
                <?php if ($selectedUserId === ''): ?>
                    Välj en användare för att visa bilder.
                <?php elseif ($selectedUserId === '__EMPTY__'): ?>
                    Inga bilder utan användare hittades.
                <?php else: ?>
                    <?php 
                    $userName = getUserFullName($selectedUserId);
                    // Debug: om användarnamn inte hittas, visa både user_id och försök att hitta användaren
                    if ($userName === '') {
                        // Låt oss försöka hitta användaren direkt från userids.json
                        $userData = [];
                        if (file_exists(__DIR__ . '/../data/userids.json')) {
                            $userContent = file_get_contents(__DIR__ . '/../data/userids.json');
                            if ($userContent !== false) {
                                $userData = json_decode($userContent, true) ?: [];
                            }
                        }
                        
                        $foundUser = null;
                        foreach ($userData as $user) {
                            if ($user['user_id'] === $selectedUserId) {
                                $foundUser = $user;
                                break;
                            }
                        }
                        
                        if ($foundUser && isset($foundUser['full_name'])) {
                            $userName = $foundUser['full_name'];
                        }
                    }
                    $displayText = $userName !== '' ? $userName : 'användare ' . htmlspecialchars($selectedUserId);
                    // Debug: visa vad som hittades
                    if ($userName === '') {
                        error_log("DEBUG: Kunde inte hitta användarnamn för user_id: " . $selectedUserId);
                    }
                    ?>
                    Inga filer uppladdade än
                <?php endif; ?>
            </div>
        <?php else: ?>
            <div class="file-grid">
                <?php foreach ($filteredUploads as $upload): ?>
                    <div class="file-item" 
                         data-project="<?= htmlspecialchars($upload['project_id']) ?>"
                         data-project-id="<?= htmlspecialchars($upload['project_id']) ?>"
                         data-upload-id="<?= htmlspecialchars($upload['upload_id'] ?? '') ?>"
                         data-user-id="<?= htmlspecialchars($upload['user_id'] ?? '') ?>"
                         data-image-path="<?= htmlspecialchars($upload['image_path']) ?>"
                         data-json-path="<?= htmlspecialchars(str_replace(['.jpg', '.png', '.heic', '.heif', '.mp4', '.webm', '.mov', '.avi'], '.json', $upload['image_path'])) ?>"
                         <?php 
                         $uid = $upload['user_id'] ?? '';
                         $uname = getUserFullName($uid);
                         $displayUser = $uname !== '' ? $uname : 'Ingen användare';
                         $displayDate = date('Y-m-d H:i', strtotime($upload['stored_at']));
                         $filename = basename($upload['image_path']);
                         $note = $upload['note'] ?? '';
                         $isVideo = ($upload['file_type'] ?? 'image') === 'video';
                         $imageNumber = isset($upload['image_number']) && is_numeric($upload['image_number']) ? (int)$upload['image_number'] : null;
                         $imageNumberText = $imageNumber !== null ? ($isVideo ? 'Video #' . $imageNumber : 'Bild #' . $imageNumber) : '';
                         
                         // Generate image_url the same way as listallp.php
                         $imageUrl = '../../view_file.php?project_id=' . urlencode($upload['project_id']) . '&file=' . urlencode(basename($upload['image_path']));
                         
                         $lightboxArgs = [
                             $imageUrl,
                             $filename,
                             $displayDate,
                             $displayUser,
                             $note,
                             $imageNumberText
                         ];
                         ?>
                         data-image-url="<?= htmlspecialchars($imageUrl) ?>"
                         data-full-image-url="<?= htmlspecialchars($imageUrl) ?>"
                         data-filename="<?= htmlspecialchars($filename) ?>"
                         data-date="<?= htmlspecialchars($displayDate) ?>"
                         data-user="<?= htmlspecialchars($displayUser) ?>"
                         data-note="<?= htmlspecialchars($note) ?>"
                         data-image-number="<?= htmlspecialchars($imageNumberText) ?>"
                         >
                        <div class="file-overlay">
                            <button class="view-btn" title="Visa fil i full storlek"><img src="../icons/view.svg" width="16" height="16" alt="Visa"></button>
                            <button class="move-btn" onclick="moveFile(this)" title="Flytta till annat projekt"><img src="../icons/move.svg" width="16" height="16" alt="Flytta"></button>
                            <button class="delete-btn" onclick="deleteFile(this)" title="Ta bort fil"><img src="../icons/delete.svg" width="16" height="16" alt="Ta bort"></button>
                            <button class="edit-btn" onclick="addDescription(this)" title="<?= empty($upload['note']) ? 'Ändra beskrivning' : 'Redigera beskrivning' ?>"><img src="../icons/edit.svg" width="16" height="16" alt="Redigera"></button>
                        </div>
                        <?php 
                        if ($isVideo): ?>
                            <video class="file-image" 
                                   controls 
                                   preload="metadata">
                                <source src="<?= htmlspecialchars($imageUrl) ?>" type="<?= htmlspecialchars($upload['mime'] ?? 'video/mp4') ?>">
                                Din webbläsare stöder inte videouppspelning.
                            </video>
                        <?php else: ?>
                            <img src="<?= htmlspecialchars($upload['thumb_url'] ?? $imageUrl) ?>" 
                                 alt="Bild" 
                                 class="file-image"
                                 loading="lazy"
                                 onerror="this.style.display='none'">
                        <?php endif; ?>
                        <div class="file-info">
                            <?php if ($imageNumberText): ?>
                                <div class="file-image-number" style="font-weight: bold; color: #1976d2; margin-bottom: 4px;">
                                    <?= htmlspecialchars($imageNumberText) ?>
                                </div>
                            <?php endif; ?>
                            <div class="file-project">
                                <?php
                                $displayName = htmlspecialchars($upload['project_name']);
                                $project_id = htmlspecialchars($upload['project_id']);
                                if (str_starts_with($displayName, $project_id . ' – ')) {
                                    $displayName = substr($displayName, strlen($project_id . ' – '));
                                }
                                echo $displayName;
                                ?>
                                <div class="file-project-name">
                                    <?= htmlspecialchars($upload['project_id']) ?>
                                </div>
                            </div>
                            <?php 
                            $uid = $upload['user_id'] ?? '';
                            $uname = getUserFullName($uid);
                            $displayUser = $uname !== '' ? htmlspecialchars($uname) : 'Ingen användare';
                            $displayDate = date('Y-m-d H:i', strtotime($upload['stored_at']));
                            $origSizeText = number_format(($upload['bytes'] ?? 0) / 1024 / 1024, 1) . 'M';
                            $thumbSizeText = '';
                            if (!empty($upload['thumb_path']) && file_exists($upload['thumb_path'])) {
                                $thumbBytes = @filesize($upload['thumb_path']);
                                if ($thumbBytes !== false) {
                                    $thumbSizeText = ' (' . number_format($thumbBytes / 1024, 1) . 'k)';
                                }
                            }
                            ?>
                            <div class="file-meta">
                                <div class="file-meta-row">
                                    <span class="file-date"><?= $displayDate ?>    <?= $origSizeText ?><?= $thumbSizeText ?></span>
                                    <span class="file-user-id">
                                        <?= $displayUser ?>
                                    </span>
                                </div>
            </div>
                            <a href="<?= htmlspecialchars($upload["image_url"]) ?>" class="file-filename" download><?= basename($upload["image_path"]) ?></a>
                            <?php if (!empty($upload['note'])): ?>
                                <div class="file-note">
                                    <?= htmlspecialchars($upload['note']) ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</div>

<style>
.file-meta {
    font-size: 12px;
    color: #666;
    display: flex;
    flex-direction: column;
    gap: 4px;
    margin-bottom: -4px;
}

.edit-btn {
    position: absolute;
    top: 8px;
    right: 119px;
    background: white;
    color: #ff9800;
    border: 2px solid #ff9800;
    border-radius: 50%;
    width: 30px;
    height: 30px;
    font-size: 16px;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    opacity: 0.9;
    transition: opacity 0.2s;
    z-index: 10;
    pointer-events: auto;
}
.edit-btn:hover {
    opacity: 1;
    background: #ff9800;
    color: white;
}
</style>

<script>
// Modal styles for description popup
const modalStyles = `
<style>
.modal {
    position: fixed;
    z-index: 1000;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, 0.5);
    display: flex;
    align-items: center;
    justify-content: center;
}

.modal-content {
    background-color: white;
    border-radius: 12px;
    width: 90%;
    max-width: 500px;
    max-height: 90vh;
    overflow-y: auto;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.3);
}

.modal-header {
    padding: 20px 20px 0 20px;
    display: flex;
    justify-content: space-between;
    align-items: center;
    border-bottom: 1px solid #eee;
    padding-bottom: 15px;
}

.modal-header h3 {
    margin: 0;
    color: #1a73e8;
}

.close {
    color: #aaa;
    font-size: 28px;
    font-weight: bold;
    cursor: pointer;
    line-height: 1;
}

.close:hover {
    color: #000;
}

.modal-body {
    padding: 20px;
}

.modal-footer {
    padding: 0 20px 20px 20px;
    display: flex;
    gap: 12px;
    justify-content: flex-end;
}

.form-group {
    margin-bottom: 20px;
}

.form-group label {
    display: block;
    font-weight: 600;
    margin-bottom: 8px;
    color: #333;
}

.form-group textarea {
    width: 100%;
    padding: 10px;
    border: 1px solid #ccc;
    border-radius: 8px;
    font-size: 16px;
    box-sizing: border-box;
    resize: vertical;
    min-height: 80px;
}

.btn-primary {
    background: #1a73e8;
    color: white;
    border: none;
    padding: 12px 20px;
    border-radius: 8px;
    font-size: 16px;
    cursor: pointer;
    font-weight: 500;
}

.btn-primary:hover {
    background: #1557b0;
}

.btn-secondary {
    background: #6c757d;
    color: white;
    border: none;
    padding: 12px 20px;
    border-radius: 8px;
    font-size: 16px;
    cursor: pointer;
    font-weight: 500;
}

.btn-secondary:hover {
    background: #5a6268;
}
</style>
`;

// Add modal styles to head
if (!document.querySelector('#description-modal-styles')) {
    const styleElement = document.createElement('div');
    styleElement.id = 'description-modal-styles';
    styleElement.innerHTML = modalStyles;
    document.head.appendChild(styleElement);
}

// Create modal HTML
const modalHTML = `
<div id="descriptionModal" class="modal" style="display: none;">
    <div class="modal-content">
        <div class="modal-header">
            <h3>Ändra beskrivning</h3>
            <span class="close" onclick="closeDescriptionModal()">&times;</span>
        </div>
        <div class="modal-body">
            <div class="form-group">
                <label for="descriptionText">Beskrivning för bilden:</label>
                <textarea id="descriptionText" rows="4" placeholder="Skriv en beskrivning för denna bild..."></textarea>
            </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn-secondary" onclick="closeDescriptionModal()">Avbryt</button>
            <button type="button" class="btn-primary" onclick="saveDescription()">Spara</button>
        </div>
    </div>
</div>
`;

// Modal functionality handled by parent file

// All modal functions handled by parent file
</script>

