<?php 
require_once __DIR__ . '/../../security.php';

// Säkerhetsheaders tidigt
setSecurityHeaders();

// Hämta user_id från GET eller cookie
if (session_status() === PHP_SESSION_NONE) {
    @session_start();
}

$rawUserId = '';
if (isset($_GET['user_id']) && $_GET['user_id'] !== '') {
    $rawUserId = $_GET['user_id'];
} elseif (isset($_COOKIE['user_id']) && $_COOKIE['user_id'] !== '') {
    $rawUserId = $_COOKIE['user_id'];
} else {
    $rawUserId = '';
}
$userId = sanitizeInput($rawUserId, 'user_id');

// Kontrollera att user_id finns
if (empty($userId)) {
    http_response_code(403);
    ?>
<!DOCTYPE html>
<html lang="sv">
<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width,initial-scale=1" />
    <title>Åtkomst nekad - ByggArkiv</title>
    <link rel="stylesheet" href="../common.css">
</head>
<body>
    <div class="container">
        <div class="card">
            <h1>Åtkomst nekad</h1>
            <p>Du måste vara inloggad för att komma åt denna sida.</p>
            <a href="../../index.html" class="btn btn-primary">Till startsidan</a>
        </div>
    </div>
</body>
</html>
    <?php
    exit;
}

// Generera admin URL precis som andra admin-sidor
$script = $_SERVER['SCRIPT_NAME'] ?? '';
$admPos = strpos($script, '/adm/');
$adminUrl = ($admPos !== false ? substr($script, 0, $admPos + 4) : '/adm') . '/admin.php';
?>
<!DOCTYPE html>
<html lang="sv">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title>Redigera Användare - ByggArkiv Admin</title>
  <link rel="stylesheet" href="../common.css">
  <style>
    /* Sid-specifika stilar för edit_user.html */
    .container { max-width: 600px; }
    .user-id-display {
      background: #f8f9fa;
      padding: 12px;
      border-radius: 8px;
      font-family: monospace;
      font-size: 16px;
      color: #333;
      margin-bottom: 20px;
    }
    
    .profile-image-section {
      padding: 20px;
      background: #f8f9fa;
      border-radius: 8px;
    }
    
    .profile-image-large {
      width: 150px;
      height: 150px;
      border-radius: 50%;
      object-fit: cover;
      border: 3px solid #e0e0e0;
      margin: 0 auto;
      display: block;
    }
    
    .profile-image-placeholder-large {
      width: 150px;
      height: 150px;
      border-radius: 50%;
      background: #e0e0e0;
      display: flex;
      align-items: center;
      justify-content: center;
      margin: 0 auto;
      color: #999;
      border: 3px solid #d0d0d0;
    }
  </style>
</head>
<body>
  <div class="container">
    <header class="header">
      <a href="../../index.html">
        <img src="../../data/logo.png" alt="ByggArkiv Snickare Stefan" class="logo">
      </a>
      <div class="back-link">
        <a href="userids.php">← Tillbaka till användarhantering</a>
      </div>
    </header>
    
    <div class="card">
      <h1>Redigera Användare</h1>
      <p class="subtitle">Uppdatera användarinformation</p>
      
      <div class="user-id-display" id="userIdDisplay">
        <!-- User ID kommer att visas här -->
      </div>
      
      <!-- Profilbild-sektion -->
      <div class="profile-image-section" style="margin-bottom: 20px; text-align: center;">
        <div id="profileImageContainer">
          <!-- Profilbild kommer att visas här -->
        </div>
        <div style="margin-top: 12px;">
          <input type="file" id="profileImageInput" accept="image/*" style="display: none;" onchange="handleProfileImageSelect(event)">
          <button type="button" class="btn-secondary" onclick="document.getElementById('profileImageInput').click()" style="margin-right: 8px;">
            Välj bild
          </button>
          <button type="button" class="btn-danger" id="deleteImageBtn" onclick="deleteProfileImage()" style="display: none;">
            Ta bort bild
          </button>
        </div>
      </div>
      
      <form id="editForm">
        <div class="form-group">
          <label for="fullName">Fullständigt namn:</label>
          <input type="text" id="fullName" name="fullName" required>
        </div>
        
        <div class="form-group">
          <label for="nickname">Nickname (valfritt, unikt):</label>
          <input type="text" id="nickname" name="nickname" placeholder="Kortnamn som visas i chatten">
          <small style="color: #666; font-size: 12px; display: block; margin-top: 4px;">
            Om satt, visas detta istället för fullständigt namn i chatten. Måste vara unikt.
          </small>
        </div>
        
        <div class="form-group">
          <label for="mobile">Mobilnummer:</label>
          <input type="text" id="mobile" name="mobile" required>
        </div>
        
        <div class="form-group">
          <div class="checkbox-group">
            <input type="checkbox" id="inactive" name="inactive">
            <label for="inactive">Markera som inaktiv (användaren är inte längre aktuell)</label>
          </div>
        </div>
        <div class="form-group">
          <div class="checkbox-group">
            <input type="checkbox" id="admin" name="admin">
            <label for="admin">Administratör (åtkomst till adminsidor)</label>
          </div>
        </div>
        
        <div class="form-group">
          <label for="pushoverUserKey">Pushover User Key:</label>
          <input type="text" id="pushoverUserKey" name="pushoverUserKey" placeholder="u1234567890abcdefghijklmnop" style="font-family: monospace;">
          <small style="color: #666; font-size: 12px; display: block; margin-top: 4px;">
            Hämta från Pushover-appen: Inställningar → Your User Key. Lämna tomt för att inaktivera Pushover-notiser.
          </small>
        </div>
        
        <div class="button-group">
          <button type="submit" class="btn-primary">Spara</button>
          <button type="button" class="btn-danger" onclick="deleteUser()">Ta bort användare</button>
          <button type="button" class="btn-secondary" onclick="goBack()">Avbryt</button>
        </div>
      </form>
      
      <div id="status" class="status"></div>
    </div>
  </div>

  <script>
    let currentUser = null;
    
    // Hämta user ID från URL-parametern
    function getUserIdFromUrl() {
      const urlParams = new URLSearchParams(window.location.search);
      return urlParams.get('user_id');
    }
    
    // Ladda användardata
    async function loadUserData() {
      const userId = getUserIdFromUrl();
      
      if (!userId) {
        showStatus('Inget user ID angivet', 'error');
        return;
      }
      
      try {
        const response = await fetch(`../api/users.php?action=get_user&user_id=${userId}`);
        const data = await response.json();
        
        if (data.success) {
          currentUser = data.user;
          // Kontrollera om användaren är extern - externa användare ska inte redigeras här
          const userType = currentUser.user_type || 'user';
          if (userType === 'extern') {
            showStatus('Externa användare kan inte redigeras här. Använd sidan för externa partners istället.', 'error');
            setTimeout(() => {
              window.location.href = '../extusers/external_parties.php';
            }, 2000);
            return;
          }
          displayUserData();
        } else {
          showStatus('Kunde inte ladda användardata: ' + data.error, 'error');
        }
      } catch (error) {
        showStatus('Fel vid laddning: ' + error.message, 'error');
      }
    }
    
    // Visa användardata i formuläret
    function displayUserData() {
      if (!currentUser) return;
      
      document.getElementById('userIdDisplay').textContent = currentUser.user_id;
      document.getElementById('fullName').value = currentUser.full_name;
      document.getElementById('nickname').value = currentUser.nickname || '';
      document.getElementById('mobile').value = currentUser.mobile;
      document.getElementById('inactive').checked = currentUser.inactive || false;
      // Sätt admin-kryssruta baserat på user_type (admin/user), inte gammalt admin-fält
      const userType = currentUser.user_type || 'user';
      document.getElementById('admin').checked = (userType === 'admin');
      document.getElementById('pushoverUserKey').value = currentUser.pushover_user_key || '';
      
      // Visa profilbild
      displayProfileImage();
    }
    
    // Visa profilbild
    function displayProfileImage() {
      const container = document.getElementById('profileImageContainer');
      const deleteBtn = document.getElementById('deleteImageBtn');
      
      if (currentUser && currentUser.profile_image) {
        const imageUrl = '../api/users.php?action=get_image&user_id=' + encodeURIComponent(currentUser.user_id) + '&t=' + Date.now();
        container.innerHTML = `<img src="${imageUrl}" alt="Profilbild" class="profile-image-large" id="profileImage">`;
        deleteBtn.style.display = 'inline-block';
      } else {
        container.innerHTML = `
          <div class="profile-image-placeholder-large">
            <svg width="64" height="64" viewBox="0 0 24 24" fill="currentColor">
              <path d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z"/>
            </svg>
          </div>
        `;
        deleteBtn.style.display = 'none';
      }
    }
    
    // Hantera filval för profilbild
    function handleProfileImageSelect(event) {
      const file = event.target.files[0];
      if (!file) return;
      
      // Kontrollera om användaren är inaktiv
      if (currentUser) {
        const isInactive = currentUser.inactive === true || currentUser.inactive === 1 || currentUser.inactive === '1' || currentUser.inactive === 'true' || 
                           (currentUser.active === false || currentUser.active === 0 || currentUser.active === '0' || currentUser.active === 'false');
        if (isInactive) {
          alert('Du kan inte ändra profilbild på en inaktiv användare');
          event.target.value = ''; // Rensa filvalet
          return;
        }
      }
      
      // Visa förhandsvisning
      const reader = new FileReader();
      reader.onload = function(e) {
        const container = document.getElementById('profileImageContainer');
        container.innerHTML = `<img src="${e.target.result}" alt="Förhandsvisning" class="profile-image-large" id="profileImage">`;
        document.getElementById('deleteImageBtn').style.display = 'inline-block';
      };
      reader.readAsDataURL(file);
      
      // Ladda upp bilden direkt
      uploadProfileImage(file);
    }
    
    // Ladda upp profilbild
    async function uploadProfileImage(file) {
      if (!currentUser) return;
      
      // Kontrollera om användaren är inaktiv
      const isInactive = currentUser.inactive === true || currentUser.inactive === 1 || currentUser.inactive === '1' || currentUser.inactive === 'true' || 
                         (currentUser.active === false || currentUser.active === 0 || currentUser.active === '0' || currentUser.active === 'false');
      if (isInactive) {
        showStatus('Du kan inte ändra profilbild på en inaktiv användare', 'error');
        displayProfileImage(); // Återställ bildvisning
        return;
      }
      
      const formData = new FormData();
      formData.append('user_id', currentUser.user_id);
      formData.append('image', file);
      
      try {
        const response = await fetch('../api/users.php?action=upload_image', {
          method: 'POST',
          body: formData
        });
        
        const data = await response.json();
        
        if (data.success) {
          // Uppdatera currentUser med ny profilbild
          currentUser.profile_image = data.profile_image;
          showStatus('Profilbild uppladdad', 'success');
        } else {
          showStatus('Kunde inte ladda upp bild: ' + data.message, 'error');
          // Återställ bildvisning
          displayProfileImage();
        }
      } catch (error) {
        showStatus('Fel vid uppladdning: ' + error.message, 'error');
        // Återställ bildvisning
        displayProfileImage();
      }
    }
    
    // Ta bort profilbild
    async function deleteProfileImage() {
      if (!currentUser) return;
      
      // Kontrollera om användaren är inaktiv
      const isInactive = currentUser.inactive === true || currentUser.inactive === 1 || currentUser.inactive === '1' || currentUser.inactive === 'true' || 
                         (currentUser.active === false || currentUser.active === 0 || currentUser.active === '0' || currentUser.active === 'false');
      if (isInactive) {
        alert('Du kan inte ta bort profilbild på en inaktiv användare');
        return;
      }
      
      if (!confirm('Är du säker på att du vill ta bort profilbilden?')) {
        return;
      }
      
      const formData = new FormData();
      formData.append('user_id', currentUser.user_id);
      
      try {
        const response = await fetch('../api/users.php?action=delete_image', {
          method: 'POST',
          body: formData
        });
        
        const data = await response.json();
        
        if (data.success) {
          delete currentUser.profile_image;
          displayProfileImage();
          showStatus('Profilbild borttagen', 'success');
        } else {
          showStatus('Kunde inte ta bort bild: ' + data.message, 'error');
        }
      } catch (error) {
        showStatus('Fel vid borttagning: ' + error.message, 'error');
      }
    }
    
    // Hantera formulärsubmit
    document.getElementById('editForm').addEventListener('submit', async function(e) {
      e.preventDefault();
      
      if (!currentUser) return;
      
      const formData = new FormData();
      formData.append('userId', currentUser.user_id);
      formData.append('fullName', document.getElementById('fullName').value.trim());
      formData.append('nickname', document.getElementById('nickname').value.trim());
      formData.append('mobile', document.getElementById('mobile').value.trim());
      formData.append('inactive', document.getElementById('inactive').checked ? '1' : '0');
      formData.append('admin', document.getElementById('admin').checked ? '1' : '0');
      formData.append('pushoverUserKey', document.getElementById('pushoverUserKey').value.trim());
      
      try {
        const response = await fetch('../api/users.php?action=update', {
          method: 'POST',
          body: formData
        });
        
        const data = await response.json();
        
        if (data.success) {
          currentUser = data.user; // Uppdatera lokala data
          // Gå tillbaka direkt utan statusmeddelande
          goBack();
        } else {
          showStatus('Kunde inte uppdatera: ' + data.error, 'error');
        }
      } catch (error) {
        showStatus('Fel vid uppdatering: ' + error.message, 'error');
      }
    });
    

    
    // Gå tillbaka
    function goBack() {
      window.location.href = 'userids.php';
    }
    
    // Visa statusmeddelande
    function showStatus(message, type) {
      const statusElement = document.getElementById('status');
      statusElement.textContent = message;
      statusElement.className = 'status ' + type;
      statusElement.style.display = 'block';
      
      // Dölj efter 5 sekunder
      setTimeout(() => {
        statusElement.style.display = 'none';
      }, 5000);
    }
    
    // Ta bort användare
    async function deleteUser() {
      if (!currentUser) {
        showStatus('Ingen användare att ta bort', 'error');
        return;
      }
      
      if (!confirm(`Är du säker på att du vill ta bort användaren "${currentUser.full_name}"?\n\nDetta kan inte ångras!`)) {
        return;
      }
      
      try {
        const formData = new FormData();
        formData.append('userId', currentUser.user_id);
        
        const response = await fetch('../api/users.php?action=delete', {
          method: 'POST',
          body: formData
        });
        
        if (!response.ok) {
          throw new Error('HTTP ' + response.status);
        }
        
        const data = await response.json();
        
        if (data.success) {
          showStatus('Användare har tagits bort', 'success');
          setTimeout(() => {
            goBack();
          }, 2000);
        } else {
          showStatus('Kunde inte ta bort användare: ' + data.message, 'error');
        }
      } catch (error) {
        showStatus('Fel vid borttagning: ' + error.message, 'error');
      }
    }
    
    // Ladda användardata när sidan laddas
    document.addEventListener('DOMContentLoaded', loadUserData);
  </script>
</body>
</html>
