<?php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../security.php';
require_once __DIR__ . '/../adm/admin_guard.php';
require_once __DIR__ . '/../lib/dal/repositories/AdminLinkStatsRepository.php';

setSecurityHeaders();

// Svara alltid JSON
header('Content-Type: application/json; charset=utf-8');

try {
    $action = $_GET['action'] ?? $_POST['action'] ?? '';
    $userId = $_GET['user_id'] ?? $_POST['user_id'] ?? $_SESSION['user_id'] ?? '';
    
    if (empty($userId)) {
        throw new Exception('User ID krävs');
    }
    
    $repo = new AdminLinkStatsRepository();
    
    switch ($action) {
        case 'record_click':
            $featureId = $_POST['feature_id'] ?? '';
            $url = $_POST['url'] ?? '';
            $title = $_POST['title'] ?? '';
            
            if (empty($featureId) || empty($url)) {
                throw new Exception('feature_id och url krävs');
            }
            
            if ($repo->recordClick($userId, $featureId, $url, $title)) {
                echo json_encode([
                    'success' => true,
                    'message' => 'Klick registrerat'
                ]);
            } else {
                throw new Exception('Kunde inte registrera klick');
            }
            break;
            
        case 'get_top':
            $limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 5;
            $topLinks = $repo->getTopLinks($userId, $limit);
            
            echo json_encode([
                'success' => true,
                'links' => $topLinks
            ]);
            break;
            
        case 'reset':
            if ($repo->resetStats($userId)) {
                echo json_encode([
                    'success' => true,
                    'message' => 'Statistik nollställd'
                ]);
            } else {
                throw new Exception('Kunde inte nollställa statistik');
            }
            break;
            
        default:
            throw new Exception('Ogiltig action: ' . $action);
    }
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>

