<?php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../security.php';
require_once __DIR__ . '/../lib/participant_helper.php';
require_once __DIR__ . '/../lib/mapping_helper.php';

// Svara alltid JSON
header('Content-Type: application/json; charset=utf-8');

// Sökväg till projects.json
$projectsFile = __DIR__ . '/../data/projects.json';

// Funktion för att läsa projekt från JSON-fil
function readProjects($filePath) {
  if (!file_exists($filePath)) {
    return [];
  }
  
  $content = file_get_contents($filePath);
  if ($content === false) {
    return [];
  }
  
  $projects = json_decode($content, true);
  return is_array($projects) ? $projects : [];
}

try {
  // Hämta user_id från GET-parameter
  $userId = sanitizeInput($_GET['user_id'] ?? '', 'string');
  
  // Kontrollera om användaren är admin
  $isAdmin = false;
  if (!empty($userId)) {
    $isAdmin = isParticipantAdmin($userId);
  }
  
  // Kontrollera användartyp
  $userType = 'user';
  if (!empty($userId)) {
    $userType = getParticipantType($userId) ?? 'user';
  }
  
  $projects = readProjects($projectsFile);
  $filteredProjects = [];
  
  if ($isAdmin) {
    // För admin: Visa alla projekt
    $filteredProjects = $projects;
  } else {
    if ($userType === 'extern') {
      // För externa användare: Visa bara projekt de är participants i
      foreach ($projects as $project) {
        if (($project['status'] ?? 'active') === 'archived') {
          continue;
        }
        
        $projectId = $project['id'] ?? '';
        if (!empty($projectId)) {
          $participants = readProjectMapping($projectId);
          foreach ($participants as $participant) {
            if (($participant['participant_id'] ?? '') === $userId) {
              $filteredProjects[] = $project;
              break;
            }
          }
        }
      }
    } else {
      // För interna användare: Visa alla aktiva projekt
      foreach ($projects as $project) {
        if (($project['status'] ?? 'active') !== 'archived') {
          $filteredProjects[] = $project;
        }
      }
    }
  }
  
  echo json_encode([
    'success' => true,
    'projects' => array_values($filteredProjects)
  ], JSON_UNESCAPED_UNICODE);
  
} catch (Exception $e) {
  http_response_code(500);
  echo json_encode([
    'success' => false,
    'message' => $e->getMessage()
  ], JSON_UNESCAPED_UNICODE);
} catch (Error $e) {
  http_response_code(500);
  echo json_encode([
    'success' => false,
    'message' => 'Ett fel uppstod: ' . $e->getMessage()
  ], JSON_UNESCAPED_UNICODE);
}
?>

