<?php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../security.php';

// Svara alltid JSON
header('Content-Type: application/json; charset=utf-8');

// Sökväg till userids.json
$userIdsFile = __DIR__ . '/../data/userids.json';

// Funktion för att läsa user IDs från JSON-fil
function readUserIds($filePath) {
  if (!file_exists($filePath)) {
    return [];
  }
  
  $content = file_get_contents($filePath);
  if ($content === false) {
    return [];
  }
  
  $userIds = json_decode($content, true);
  return is_array($userIds) ? $userIds : [];
}

// Hämta action och user_id från URL
$action = $_GET['action'] ?? 'get';
$userId = $_GET['user_id'] ?? '';

try {
  $userIds = readUserIds($userIdsFile);
  
  // Hantera action=list - returnera alla användare (endast för admin)
  if ($action === 'list') {
    // Kontrollera admin-rättigheter - använd participant_helper för konsistens
    require_once __DIR__ . '/../lib/participant_helper.php';
    $isAdmin = false;
    if (!empty($userId)) {
      $isAdmin = isParticipantAdmin($userId);
      error_log("DEBUG get_user_info.php: user_id=$userId, isAdmin=" . ($isAdmin ? 'true' : 'false'));
    } else {
      error_log("DEBUG api/user_info.php: Ingen user_id angiven");
    }
    
    if (!$isAdmin) {
      http_response_code(403);
      echo json_encode([
        'success' => false,
        'message' => 'Endast admin kan lista användare'
      ]);
      exit;
    }
    
    // Returnera alla användare (utan känslig info som password)
    $safeUsers = array_map(function($user) {
      return [
        'user_id' => $user['user_id'] ?? '',
        'full_name' => $user['full_name'] ?? '',
        'mobile' => $user['mobile'] ?? '',
        'user_type' => $user['user_type'] ?? 'user',
        'active' => $user['active'] ?? true,
        'pushover_user_key' => $user['pushover_user_key'] ?? '',
        'nickname' => $user['nickname'] ?? ''
      ];
    }, $userIds);
    
    echo json_encode([
      'success' => true,
      'users' => array_values($safeUsers)
    ]);
    exit;
  }
  
  // Default action: get - hämta specifik användare
  if (empty($userId)) {
    http_response_code(400);
    echo json_encode([
      'success' => false,
      'message' => 'User ID krävs'
    ]);
    exit;
  }
  
  $userFound = false;
  
  foreach ($userIds as $user) {
    // Kontrollera både user_id och uuid
    if ($user['user_id'] === $userId || (isset($user['uuid']) && $user['uuid'] === $userId)) {
      echo json_encode([
        'success' => true,
        'user' => $user
      ]);
      $userFound = true;
      break;
    }
  }
  
  if (!$userFound) {
    http_response_code(404);
    echo json_encode([
      'success' => false,
      'message' => 'Användare hittades inte'
    ]);
  }
  
} catch (Exception $e) {
  http_response_code(500);
  echo json_encode([
    'success' => false,
    'message' => $e->getMessage()
  ]);
}
?>
