<?php
require_once __DIR__ . '/../security.php';
require_once __DIR__ . '/../config.php';

// Säkerhetsheaders
setSecurityHeaders();

// Hämta parametrar
$projectId = sanitizeInput($_GET['project_id'] ?? '', 'project_id');
$mediaFile = sanitizeInput($_GET['media_file'] ?? '', 'filename');
$customName = sanitizeInput($_GET['filename'] ?? '', 'string');

if (empty($projectId) || empty($mediaFile)) {
    http_response_code(400);
    exit('Ogiltiga parametrar');
}

// Säkerställ att filnamnet är säkert
if (!preg_match('/^[a-zA-Z0-9_.-]+$/', $mediaFile)) {
    http_response_code(400);
    exit('Ogiltigt filnamn');
}

// Konstruera filsökväg
$filePath = __DIR__ . '/../chats/' . $projectId . '/' . $mediaFile;

// Kontrollera att filen finns
if (!file_exists($filePath) || !is_file($filePath)) {
    http_response_code(404);
    exit('Filen hittades inte');
}

// Kontrollera filtyp och sätt rätt MIME-typ
$finfo = new finfo(FILEINFO_MIME_TYPE);
$mimeType = $finfo->file($filePath);

// Bestäm om det är en bild baserat på MIME-typ
$isImage = strpos($mimeType, 'image/') === 0;

// Bestäm filnamn för nedladdning
$downloadName = $customName ?: $mediaFile;

// Se till att filnamnet har rätt filändelse
$originalExt = pathinfo($mediaFile, PATHINFO_EXTENSION);
if (!empty($customName) && pathinfo($customName, PATHINFO_EXTENSION) === '') {
    $downloadName .= '.' . $originalExt;
}

// Säkra filnamnet för HTTP-header
$safeDownloadName = basename($downloadName);

// Sätt headers
header('Content-Type: ' . $mimeType);
header('Content-Length: ' . filesize($filePath));

// För bilder: använd inline för visning, annars attachment för nedladdning
// Om customName finns, användaren vill ladda ner, annars visa inline (för bilder)
if ($isImage && empty($customName)) {
    // Bild utan filename-parameter = visa inline i chatten
    header('Content-Disposition: inline; filename="' . $safeDownloadName . '"');
    header('Cache-Control: public, max-age=3600'); // Cache i 1 timme för bilder
} else {
    // Dokument eller bild med filename-parameter = nedladdning
    header('Content-Disposition: attachment; filename="' . $safeDownloadName . '"');
    header('Cache-Control: no-cache, must-revalidate');
    header('Expires: 0');
}

// Outputa filen
readfile($filePath);
exit;
?>
