<?php
// ======= Grundkonfig =======

// PHP-konfiguration (server-inställningar kan inte ändras via ini_set)
// Aktuella server-gränser: upload_max_filesize=32M, post_max_size=32M

// Admin-lösenord hanteras via admin_users.json 
// PIN-kod för användaruppladdningar är inaktiverad som standard

// Rotmapp för uppladdningar.
// För enkel start: relativt denna katalog. För produktion: peka mot en delad mapp.
// Exempel: '/volume1/ProjektBilder' (se till att "http"-användaren har skrivrätt)
define('UPLOAD_ROOT', 'uploads');

// Tillåtna MIME-typer för bilder (snickare)
global $ALLOWED_IMAGE_MIME;
$ALLOWED_IMAGE_MIME = [
  'image/jpeg' => 'jpg',
  'image/jpg'  => 'jpg',  // Vissa system kan rapportera image/jpg
  'image/pjpeg' => 'jpg', // Progressiv JPEG
  'image/png'  => 'png',
  'image/webp' => 'webp', // WebP-bilder (Google's format)
  'image/heic' => 'heic', // iPhones kan ge HEIC
  'image/heif' => 'heif'
];

// Tillåtna MIME-typer för dokument (administratörer)
global $ALLOWED_DOCUMENT_MIME;
$ALLOWED_DOCUMENT_MIME = [
  'application/pdf' => 'pdf', // PDF-dokument
  'application/x-pdf' => 'pdf', // PDF-dokument (alternativ MIME)
  'text/plain' => 'txt',      // Textfiler
  'text/csv' => 'csv'         // CSV-filer
];

// Tillåtna MIME-typer för videor
global $ALLOWED_VIDEO_MIME;
$ALLOWED_VIDEO_MIME = [
  'video/mp4' => 'mp4',       // MP4-videor
  'video/webm' => 'webm',     // WebM-videor
  'video/quicktime' => 'mov', // QuickTime-videor
  'video/x-msvideo' => 'avi'  // AVI-videor
];

// Bakåtkompatibilitet
$ALLOWED_MIME = array_merge($ALLOWED_IMAGE_MIME, $ALLOWED_DOCUMENT_MIME, $ALLOWED_VIDEO_MIME);

// Max filstorlek i byte (server-sida; klienten påverkas av PHP ini också)
define('MAX_FILE_BYTES', 32 * 1024 * 1024); // 25 MB för bilder och dokument

// Max filstorlek för videor (anpassad till server-gränser)
define('MAX_VIDEO_BYTES', 32 * 1024 * 1024); // 32 MB för videor (server limit)

// Tidszon (för filnamn)
date_default_timezone_set('Europe/Stockholm');

// ======= Datastore-konfiguration =======
// Välj datastore-typ: 'json' eller 'mysql'
// Standard är 'json' för bakåtkompatibilitet
if (!defined('DATA_STORE_TYPE')) {
    define('DATA_STORE_TYPE', 'json');
}

// ======= Databaskonfiguration =======
// Välj vilken databaskonfiguration som ska användas: 'primary' eller 'secondary'
// Standard är 'primary' om inte annat anges
if (!defined('DB_CONFIG')) {
    define('DB_CONFIG', 'primary');
}

// ======= Primär databaskonfiguration =======
// Används när DB_CONFIG är 'primary' eller om sekundär konfiguration inte är definierad
if (!defined('DB_PRIMARY_HOST')) {
    define('DB_PRIMARY_HOST', 'localhost');
}
if (!defined('DB_PRIMARY_NAME')) {
    define('DB_PRIMARY_NAME', 'byggarkiv');
}
if (!defined('DB_PRIMARY_USER')) {
    define('DB_PRIMARY_USER', 'root');
}
if (!defined('DB_PRIMARY_PASS')) {
    define('DB_PRIMARY_PASS', '');
}
if (!defined('DB_PRIMARY_TABLE_PREFIX')) {
    define('DB_PRIMARY_TABLE_PREFIX', '');
}

// ======= Sekundär databaskonfiguration =======
// Används när DB_CONFIG är 'secondary'
// Lämna dessa tomma om du bara använder en databas
if (!defined('DB_SECONDARY_HOST')) {
    define('DB_SECONDARY_HOST', 'localhost');
}
if (!defined('DB_SECONDARY_NAME')) {
    define('DB_SECONDARY_NAME', 'byggarkiv_secondary');
}
if (!defined('DB_SECONDARY_USER')) {
    define('DB_SECONDARY_USER', 'root');
}
if (!defined('DB_SECONDARY_PASS')) {
    define('DB_SECONDARY_PASS', '');
}
if (!defined('DB_SECONDARY_TABLE_PREFIX')) {
    define('DB_SECONDARY_TABLE_PREFIX', '');
}

// ======= Bakåtkompatibilitet =======
// Gamla konstanter (DB_HOST, DB_NAME, etc.) mappas till primär konfiguration
// om de är definierade, annars används primär konfiguration
if (!defined('DB_HOST')) {
    define('DB_HOST', DB_PRIMARY_HOST);
}
if (!defined('DB_NAME')) {
    define('DB_NAME', DB_PRIMARY_NAME);
}
if (!defined('DB_USER')) {
    define('DB_USER', DB_PRIMARY_USER);
}
if (!defined('DB_PASS')) {
    define('DB_PASS', DB_PRIMARY_PASS);
}
if (!defined('DB_TABLE_PREFIX')) {
    define('DB_TABLE_PREFIX', DB_PRIMARY_TABLE_PREFIX);
}

// ======= Notifikationskonfiguration =======
// Välj vilken notifieringsprovider som ska användas
// Möjliga värden: 'none', 'pushover', eller anpassade providers
// Konfiguration för respektive provider finns i respektive provider-fil (t.ex. chat/providers/pushover_provider.php)
//define('NOTIFICATION_PROVIDER', 'none');
define('NOTIFICATION_PROVIDER', 'pushover');
// Session-konfiguration och start
if (session_status() === PHP_SESSION_NONE) {
    // Endast ändra ini innan session startas
    ini_set('session.cookie_lifetime', 28800); // 8 timmar
    ini_set('session.gc_maxlifetime', 28800);  // 8 timmar
    ini_set('session.cookie_secure', isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 1 : 0);
    ini_set('session.cookie_httponly', 1);     // Säkerhet
    ini_set('session.use_strict_mode', 1);     // Säkerhet
    session_start();
}