<?php
/**
 * Interface för datastores (JSON eller MySQL)
 * Definierar gemensamma metoder för datalagring
 */
interface DataStoreInterface {
    /**
     * Hämta data från en nyckel
     * @param string $key Nyckel för data
     * @return mixed Data eller null om inte hittad
     */
    public function get($key);
    
    /**
     * Spara data med en nyckel
     * @param string $key Nyckel för data
     * @param mixed $data Data att spara
     * @return bool True om lyckat, false annars
     */
    public function set($key, $data);
    
    /**
     * Ta bort data med en nyckel
     * @param string $key Nyckel för data
     * @return bool True om lyckat, false annars
     */
    public function delete($key);
    
    /**
     * Kontrollera om en nyckel finns
     * @param string $key Nyckel att kontrollera
     * @return bool True om nyckel finns, false annars
     */
    public function exists($key);
    
    /**
     * Hämta alla nycklar (för vissa implementationer)
     * @param string $prefix Prefix för att filtrera nycklar (valfritt)
     * @return array Array med nycklar
     */
    public function getAllKeys($prefix = '');
    
    /**
     * Hämta flera värden på en gång
     * @param array $keys Array med nycklar
     * @return array Associativ array med nyckel => värde
     */
    public function getMultiple($keys);
    
    /**
     * Spara flera värden på en gång
     * @param array $data Associativ array med nyckel => värde
     * @return bool True om alla lyckades, false annars
     */
    public function setMultiple($data);
}
?>




